/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class StringEditorTable {
    private static final String CUSTOM_EDITABLE_LIST_VALUE_KEY = "CUSTOM_EDITABLE_LIST_VALUE";

    public static Table createEditableList(@NotNull Composite parent, @NotNull String name, @Nullable List<String> values, @Nullable DBPImage icon, @Nullable IContentProposalProvider proposalProvider) {
        return StringEditorTable.createCustomEditableList(parent, name, values, new StringValuesManager(icon), proposalProvider, false);
    }

    public static <T> Table createCustomEditableList(@NotNull Composite parent, @NotNull String name, @Nullable List<T> values, final @NotNull TableValuesManager<T> valuesManager, final @Nullable IContentProposalProvider proposalProvider, boolean withReordering) {
        Group group = UIUtils.createControlGroup(parent, name, 2, 1808, 0);
        final Table valueTable = new Table((Composite)group, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        valueTable.setLayoutData((Object)gd);
        valueTable.setLinesVisible(true);
        final TableColumn valueColumn = UIUtils.createTableColumn(valueTable, 16384, UIMessages.properties_value);
        valueTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                valueColumn.setWidth(valueTable.getClientArea().width);
            }
        });
        valueTable.removeAll();
        if (!CommonUtils.isEmpty(values)) {
            for (T value : values) {
                TableItem tableItem = new TableItem(valueTable, 16384);
                tableItem.setText(valuesManager.getString(value));
                StringEditorTable.setCustomValue(tableItem, value);
                DBPImage icon = valuesManager.getIcon(value);
                tableItem.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
            }
        }
        final CustomTableEditor tableEditor = new CustomTableEditor(valueTable){
            {
                super($anonymous0);
                this.firstTraverseIndex = 0;
                this.lastTraverseIndex = 0;
            }

            @Override
            protected Control createEditor(Table table, int index, TableItem item) {
                Text editor;
                if (valuesManager.isEditable(StringEditorTable.getCustomValue(item)).booleanValue()) {
                    editor = new Text((Composite)table, 2048);
                    editor.setText(item.getText());
                    editor.addModifyListener(e -> this.saveEditorValue((Control)editor, index, item));
                    if (proposalProvider != null) {
                        this.setProposalAdapter(ContentAssistUtils.installContentProposal((Control)editor, (IControlContentAdapter)new SmartTextContentAdapter(), proposalProvider));
                    }
                } else {
                    editor = null;
                }
                return editor;
            }

            @Override
            protected void saveEditorValue(Control control, int index, TableItem item) {
                String text = ((Text)control).getText().trim();
                Object value = valuesManager.prepareNewValue(StringEditorTable.getCustomValue(item), text);
                if (value != null) {
                    StringEditorTable.setCustomValue(item, value);
                    item.setText(valuesManager.getString(value));
                    DBPImage icon = valuesManager.getIcon(value);
                    item.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
                }
            }
        };
        Composite rightArea = UIUtils.createPlaceholder((Composite)group, 1, 5);
        rightArea.setLayoutData((Object)new GridData(1040));
        final var buttonsRefresher = new Object(){
            public Runnable refreshButtons;
        };
        Composite buttonsGroup = UIUtils.createPlaceholder(rightArea, 1, 5);
        buttonsGroup.setLayoutData((Object)new GridData(2));
        Button addButton = new Button(buttonsGroup, 8);
        addButton.setText(UIMessages.button_add);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem newItem = new TableItem(valueTable, 16384);
                DBPImage icon = valuesManager.getIcon(null);
                newItem.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
                valueTable.setSelection(newItem);
                tableEditor.closeEditor();
                tableEditor.showEditor(newItem);
                buttonsRefresher.refreshButtons.run();
            }
        });
        Button removeButton = new Button(buttonsGroup, 8);
        removeButton.setText(UIMessages.button_remove);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = valueTable.getSelectionIndex();
                if (selectionIndex >= 0) {
                    tableEditor.closeEditor();
                    valueTable.remove(selectionIndex);
                    buttonsRefresher.refreshButtons.run();
                }
            }
        });
        removeButton.setEnabled(false);
        Button clearButton = new Button(buttonsGroup, 8);
        clearButton.setText(UIMessages.button_clear);
        clearButton.setLayoutData((Object)new GridData(768));
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableEditor.closeEditor();
                valueTable.removeAll();
                buttonsRefresher.refreshButtons.run();
            }
        });
        Composite bottomButtonsGroup = UIUtils.createPlaceholder(rightArea, 1, 5);
        bottomButtonsGroup.setLayoutData((Object)new GridData(2, 2, true, true));
        Button upButton = new Button(bottomButtonsGroup, 8);
        upButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_UP));
        upButton.setLayoutData((Object)new GridData(768));
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = valueTable.getSelectionIndex();
                if (selectionIndex >= 1 && selectionIndex < valueTable.getItemCount()) {
                    Object value = StringEditorTable.getCustomValue(valueTable.getItem(selectionIndex));
                    valueTable.remove(selectionIndex);
                    TableItem tableItem = new TableItem(valueTable, 16384, selectionIndex - 1);
                    tableItem.setText(valuesManager.getString(value));
                    StringEditorTable.setCustomValue(tableItem, value);
                    DBPImage icon = valuesManager.getIcon(value);
                    tableItem.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
                    valueTable.setSelection(selectionIndex - 1);
                    buttonsRefresher.refreshButtons.run();
                }
            }
        });
        upButton.setVisible(withReordering);
        Button downButton = new Button(bottomButtonsGroup, 8);
        downButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ARROW_DOWN));
        downButton.setLayoutData((Object)new GridData(768));
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = valueTable.getSelectionIndex();
                if (selectionIndex >= 0 && selectionIndex < valueTable.getItemCount() - 1) {
                    Object value = StringEditorTable.getCustomValue(valueTable.getItem(selectionIndex));
                    valueTable.remove(selectionIndex);
                    TableItem tableItem = new TableItem(valueTable, 16384, selectionIndex + 1);
                    tableItem.setText(valuesManager.getString(value));
                    StringEditorTable.setCustomValue(tableItem, value);
                    DBPImage icon = valuesManager.getIcon(value);
                    tableItem.setImage(icon == null ? null : DBeaverIcons.getImage(icon));
                    valueTable.setSelection(selectionIndex + 1);
                    buttonsRefresher.refreshButtons.run();
                }
            }
        });
        downButton.setVisible(withReordering);
        valueTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                buttonsRefresher.refreshButtons.run();
            }
        });
        buttonsRefresher.refreshButtons = () -> {
            int selectionIndex = valueTable.getSelectionIndex();
            if (selectionIndex < 0) {
                removeButton.setEnabled(false);
                upButton.setEnabled(false);
                downButton.setEnabled(false);
            } else {
                removeButton.setEnabled(true);
                upButton.setEnabled(selectionIndex > 0);
                downButton.setEnabled(selectionIndex < valueTable.getItemCount() - 1);
            }
        };
        return valueTable;
    }

    public static void replaceAllStringValues(Table valueTable, List<String> values, DBPImage icon) {
        valueTable.removeAll();
        if (!CommonUtils.isEmpty(values)) {
            for (String value : values) {
                TableItem tableItem = new TableItem(valueTable, 16384);
                tableItem.setText(value);
                StringEditorTable.setCustomValue(tableItem, value);
                if (icon == null) continue;
                tableItem.setImage(DBeaverIcons.getImage(icon));
            }
        }
    }

    public static List<String> collectStringValues(Table table) {
        ArrayList<String> values = new ArrayList<String>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String value = item.getText().trim();
            if (!value.isEmpty()) {
                values.add(value);
            }
            ++n2;
        }
        return values;
    }

    public static <T> List<T> collectCustomValues(@NotNull Table table) {
        ArrayList<T> values = new ArrayList<T>(table.getItemCount());
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            T value = StringEditorTable.getCustomValue(item);
            if (value != null) {
                values.add(value);
            }
            ++n2;
        }
        return values;
    }

    private static <T> T getCustomValue(TableItem tableItem) {
        return (T)tableItem.getData(CUSTOM_EDITABLE_LIST_VALUE_KEY);
    }

    private static <T> void setCustomValue(TableItem tableItem, T value) {
        tableItem.setData(CUSTOM_EDITABLE_LIST_VALUE_KEY, value);
    }

    private record StringValuesManager(@Nullable DBPImage icon) implements TableValuesManager<String>
    {
        @Override
        @Nullable
        public DBPImage getIcon(@Nullable String value) {
            return this.icon;
        }

        @Override
        @NotNull
        public String getString(@Nullable String value) {
            return value == null ? "" : value;
        }

        @Override
        @NotNull
        public Boolean isEditable(@Nullable String value) {
            return true;
        }

        @Override
        @Nullable
        public String prepareNewValue(@Nullable String originalValue, @Nullable String string) {
            return string;
        }
    }

    public static interface TableValuesManager<T> {
        @Nullable
        public DBPImage getIcon(@Nullable T var1);

        @NotNull
        public String getString(@Nullable T var1);

        @NotNull
        public Boolean isEditable(@Nullable T var1);

        @Nullable
        public T prepareNewValue(@Nullable T var1, @Nullable String var2);
    }
}

