/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.rpc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceServer;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.DataSourceUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverCommandLine;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorHandlerOpenEditor;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RestClient;

public class DBeaverInstanceServer
extends ApplicationInstanceServer<IInstanceController>
implements IInstanceController {
    private static final Log log = Log.getLog(DBeaverInstanceServer.class);
    private DBPDataSourceContainer dataSourceContainer = null;
    private final List<File> filesToConnect = new ArrayList<File>();

    private DBeaverInstanceServer() throws IOException {
        super(IInstanceController.class);
    }

    @Nullable
    public static DBeaverInstanceServer createServer() throws IOException {
        if (DBeaverInstanceServer.createClient() != null) {
            log.debug((Object)"Can't start instance server because other instance is already running");
            return null;
        }
        return new DBeaverInstanceServer();
    }

    @Nullable
    public static IInstanceController createClient() {
        return DBeaverInstanceServer.createClient(null);
    }

    @Nullable
    public static IInstanceController createClient(@Nullable String workspacePath) {
        Path path = DBeaverInstanceServer.getConfigPath((String)workspacePath);
        if (Files.notExists(path, new LinkOption[0])) {
            log.trace((Object)"No instance controller is available");
            return null;
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = Files.newBufferedReader(path);){
                properties.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)("Error reading instance controller configuration: " + e.getMessage()));
            return null;
        }
        String port = properties.getProperty("port");
        if (CommonUtils.isEmptyTrimmed((String)port)) {
            log.error((Object)"No port specified for the instance controller to connect to");
            return null;
        }
        IInstanceController instance = (IInstanceController)RestClient.builder((URI)URI.create("http://localhost:" + port), IInstanceController.class).setSslContext(DBeaverInstanceServer.initCustomSslContext()).create();
        try {
            long payload = System.currentTimeMillis();
            long response = instance.ping(payload);
            if (response != payload) {
                throw new IllegalStateException("Invalid ping response: " + response + ", was expecting " + payload);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error accessing instance server: " + e.getMessage()));
            return null;
        }
        return instance;
    }

    @Nullable
    private static SSLContext initCustomSslContext() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(KeyStore.getInstance(KeyStore.getDefaultType()));
            SSLContext ssl = SSLContext.getInstance("TLS");
            ssl.init(null, factory.getTrustManagers(), null);
            return ssl;
        }
        catch (Exception e) {
            log.error((Object)("Error init custom ssl context: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public CLIProcessResult handleCommandLine(@NotNull String[] args) {
        CommandLine cmd = DBeaverCommandLine.getInstance().getCommandLine(args);
        try {
            return DBeaverCommandLine.getInstance().executeCommandLineCommands(cmd, this, !DBeaverApplication.getInstance().isHeadlessMode());
        }
        catch (Exception e) {
            return new CLIProcessResult(CLIProcessResult.PostAction.ERROR, "Error executing command: " + e.getMessage());
        }
    }

    public long ping(long payload) {
        return payload;
    }

    @Override
    public void openExternalFiles(@NotNull String[] fileNames) {
        UIUtils.asyncExec(() -> {
            List paths = EditorUtils.openExternalFiles((String[])fileNames, (DBPDataSourceContainer)this.dataSourceContainer);
            this.filesToConnect.addAll(paths.stream().map(Path::toFile).toList());
        });
    }

    @Override
    public void openDatabaseConnection(@NotNull String connectionSpec) {
        ApplicationInstanceServer.InstanceConnectionParameters instanceConParameters = new ApplicationInstanceServer.InstanceConnectionParameters();
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (activeProject == null) {
            log.error((Object)"No active project in workspace");
            return;
        }
        this.dataSourceContainer = DataSourceUtils.getDataSourceBySpec((DBPProject)activeProject, (String)GeneralUtils.replaceVariables((String)connectionSpec, (IVariableResolver)SystemVariablesResolver.INSTANCE), (GeneralUtils.IParameterHandler)instanceConParameters, (boolean)false, (boolean)instanceConParameters.isCreateNewConnection());
        if (this.dataSourceContainer == null) {
            this.filesToConnect.clear();
            return;
        }
        if (!CommonUtils.isEmpty(this.filesToConnect)) {
            for (File file : this.filesToConnect) {
                EditorUtils.setFileDataSource((File)file, (DatabaseEditorContext)new SQLNavigatorContext((DBSObject)this.dataSourceContainer));
            }
        }
        if (instanceConParameters.isOpenConsole()) {
            IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
            UIUtils.syncExec(() -> {
                SQLEditorHandlerOpenEditor.openSQLConsole((IWorkbenchWindow)workbenchWindow, (SQLNavigatorContext)new SQLNavigatorContext((DBSObject)this.dataSourceContainer), (String)this.dataSourceContainer.getName(), (String)"");
                workbenchWindow.getShell().forceActive();
            });
        } else if (instanceConParameters.isMakeConnect()) {
            DataSourceHandler.connectToDataSource(null, (DBPDataSourceContainer)this.dataSourceContainer, null);
        }
        this.filesToConnect.clear();
    }

    @Override
    public void quit() {
        log.info((Object)"Program termination requested");
        new Job("Terminate application"){

            protected IStatus run(IProgressMonitor monitor) {
                System.exit(-1);
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
    }

    @Override
    public void closeAllEditors() {
        log.debug((Object)"Close all open editor tabs");
        UIUtils.syncExec(() -> {
            IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                page.closeAllEditors(false);
            }
        });
    }

    @Override
    public void executeWorkbenchCommand(@NotNull String commandId) {
        log.debug((Object)("Execute workbench command " + commandId));
        ActionUtils.runCommand((String)commandId, (IServiceLocator)UIUtils.getActiveWorkbenchWindow());
    }

    @Override
    public void fireGlobalEvent(@NotNull String eventId, @NotNull Map<String, Object> properties) {
        DBPPlatformDesktop.getInstance().getGlobalEventManager().fireGlobalEvent(eventId, properties);
    }

    @Override
    public void bringToFront() {
        UIUtils.syncExec(() -> {
            Shell shell = UIUtils.getActiveShell();
            if (shell != null) {
                if (!shell.getMinimized()) {
                    shell.setMinimized(true);
                }
                shell.setMinimized(false);
                shell.setActive();
            }
        });
    }
}

