/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.DamengConstants;
import org.jkiss.dbeaver.ext.dameng.model.DamengExecutionContext;
import org.jkiss.dbeaver.ext.dameng.model.DamengRole;
import org.jkiss.dbeaver.ext.dameng.model.DamengSQLDialect;
import org.jkiss.dbeaver.ext.dameng.model.DamengSchema;
import org.jkiss.dbeaver.ext.dameng.model.DamengTablespace;
import org.jkiss.dbeaver.ext.dameng.model.DamengUser;
import org.jkiss.dbeaver.ext.dameng.model.DamengUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DamengDataSource
extends GenericDataSource {
    private final TablespaceCache tablespaceCache = new TablespaceCache();
    private final UserCache userCache = new UserCache();
    private final RoleCache roleCache = new RoleCache();

    public DamengDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new DamengSQLDialect());
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new DamengExecutionContext(instance, type);
    }

    protected void initializeContextState(DBRProgressMonitor monitor, JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        DamengExecutionContext executionContext = (DamengExecutionContext)context;
        if (initFrom == null) {
            executionContext.refreshDefaults(monitor, true);
            return;
        }
        DamengExecutionContext executionMetaContext = (DamengExecutionContext)initFrom;
        DamengSchema defaultSchema = executionMetaContext.getDefaultSchema();
        if (defaultSchema != null) {
            executionContext.setDefaultSchema(monitor, defaultSchema);
        }
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, JDBCDatabaseMetaData metaData) {
        return new JDBCDataSourceInfo(metaData);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.tablespaceCache.clearCache();
        return this;
    }

    public DBPDataKind resolveDataKind(String typeName, int valueType) {
        return DamengDataSource.getDataKind(typeName, valueType);
    }

    @NotNull
    public static DBPDataKind getDataKind(@NotNull String typeName, int valueType) {
        if (valueType == 2000 && DamengConstants.INTERVAL_TYPES.contains(typeName)) {
            return DBPDataKind.DATETIME;
        }
        return GenericDataSource.getDataKind((String)typeName, (int)valueType);
    }

    @Nullable
    public DamengTablespace getTablespaceById(DBRProgressMonitor monitor, long tableSpaceId) throws DBException {
        return (DamengTablespace)DamengUtils.getObjectById(monitor, this.tablespaceCache, this, tableSpaceId);
    }

    @Nullable
    public DamengUser getUserById(DBRProgressMonitor monitor, long userId) throws DBException {
        return (DamengUser)DamengUtils.getObjectById(monitor, this.userCache, this, userId);
    }

    @Association
    public Collection<DamengTablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        return this.tablespaceCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DamengUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DamengRole> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public TablespaceCache getTablespaceCache() {
        return this.tablespaceCache;
    }

    static class RoleCache
    extends JDBCObjectCache<DamengDataSource, DamengRole> {
        RoleCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DamengDataSource damengDataSource) throws SQLException {
            return session.prepareStatement("SELECT\nID,\nNAME,\nINFO1,\nVALID,\nCRTDATE\nFROM\nSYSOBJECTS\nWHERE\nTYPE$ = 'UR'\nAND SUBTYPE$ = 'ROLE'\nAND (INFO2 IS NULL\nOR INFO2 != 1)\nAND INFO1 = 0\nORDER BY\nNAME");
        }

        protected DamengRole fetchObject(@NotNull JDBCSession session, @NotNull DamengDataSource damengDataSource, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new DamengRole(damengDataSource, resultSet);
        }
    }

    public static class TablespaceCache
    extends JDBCObjectCache<DamengDataSource, DamengTablespace> {
        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DamengDataSource dataSource) throws SQLException {
            return session.prepareStatement("SELECT * FROM V$TABLESPACE");
        }

        protected DamengTablespace fetchObject(@NotNull JDBCSession session, @NotNull DamengDataSource dataSource, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new DamengTablespace(dataSource, resultSet);
        }
    }

    static class UserCache
    extends JDBCObjectCache<DamengDataSource, DamengUser> {
        UserCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DamengDataSource dataSource) throws SQLException {
            return session.prepareStatement("SELECT\nUSER_OBJ.*,\nSYSUSERS.*,\nTS.ID AS TABLESPACE_ID,\nTS.NAME AS TABLESPACE\nFROM\nSYSOBJECTS USER_OBJ\nLEFT JOIN SYSUSERS ON\nSYSUSERS.ID = USER_OBJ.ID\nLEFT JOIN SYS.V$TABLESPACE TS ON\nUSER_OBJ.INFO3 & 0x000000000000FFFF = TS.ID\nWHERE\nUSER_OBJ.SUBTYPE$ = 'USER'");
        }

        protected DamengUser fetchObject(@NotNull JDBCSession session, @NotNull DamengDataSource dataSource, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new DamengUser(dataSource, resultSet);
        }
    }
}

