/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.app;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplicationContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.app.DPIPlatform;
import org.jkiss.dbeaver.dpi.model.client.ConfigUtils;
import org.jkiss.dbeaver.dpi.server.DPIRestServer;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.dpi.DBPApplicationDPI;
import org.jkiss.dbeaver.model.impl.app.BaseApplicationImpl;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DPIApplication
extends BaseApplicationImpl
implements DBPApplicationDPI {
    private static final Log log = Log.getLog(DPIApplication.class);
    private final Map<String, String[]> driverLibsLocation = new ConcurrentHashMap<String, String[]>();
    private boolean environmentVariablesAccessible = false;

    public boolean isHeadlessMode() {
        return true;
    }

    public boolean isDetachedProcess() {
        return true;
    }

    @NotNull
    public Object start(IApplicationContext context) {
        this.initializeApplicationServices();
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        try {
            String enableEnvVariablesArgument = this.getCommandLineArgument("-envVariablesEnabled");
            if (CommonUtils.isNotEmpty((String)enableEnvVariablesArgument)) {
                this.environmentVariablesAccessible = Boolean.parseBoolean(enableEnvVariablesArgument);
            }
            this.runServer(context, application);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        log.debug((Object)"Exiting DPI application");
        return EXIT_OK;
    }

    private void runServer(IApplicationContext appContext, DBPApplication application) throws IOException {
        int portNumber = IOUtils.findFreePort((int)20000, (int)65000);
        DPIRestServer server = new DPIRestServer(application, portNumber);
        this.saveServerInfo(portNumber);
        try {
            log.debug((Object)("Started DPI Server at " + portNumber));
            server.join();
        }
        finally {
            this.deleteServerInfo();
        }
    }

    private void saveServerInfo(int portNumber) throws IOException {
        Path serverIniFile = this.getServerIniFile();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter out = Files.newBufferedWriter(serverIniFile, StandardOpenOption.CREATE);){
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            props.put("serverPort", String.valueOf(portNumber));
            props.put("startTime", new Date().toString());
            ConfigUtils.storeProperties((BufferedWriter)out, props);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void deleteServerInfo() throws IOException {
        Path serverIniFile = this.getServerIniFile();
        if (Files.exists(serverIniFile, new LinkOption[0])) {
            Files.delete(serverIniFile);
        }
    }

    @NotNull
    private Path getServerIniFile() throws IOException {
        String configPath = System.getProperty("osgi.configuration.area");
        if (configPath == null) {
            throw new IOException("OSGI configuration area property not set");
        }
        Path configFolder = Path.of(configPath = this.normalizeFileReference(configPath), new String[0]);
        if (!Files.exists(configFolder, new LinkOption[0])) {
            throw new IOException("Configuration folder '" + String.valueOf(configFolder) + "' doesn't exists");
        }
        Path serverIniFile = configFolder.resolve("server.ini");
        return serverIniFile;
    }

    @NotNull
    private String normalizeFileReference(String configPath) {
        if (configPath.startsWith("file:")) {
            configPath = configPath.substring(configPath.indexOf(58) + 1);
        }
        while (configPath.contains(":/") && configPath.startsWith("/")) {
            configPath = configPath.substring(1);
        }
        return configPath;
    }

    public void stop() {
        System.out.println("Stopping DPI application");
        super.stop();
    }

    @Nullable
    public Path getDefaultWorkingFolder() {
        return null;
    }

    @NotNull
    public Class<? extends DBPPlatform> getPlatformClass() {
        return DPIPlatform.class;
    }

    public boolean isEnvironmentVariablesAccessible() {
        return this.environmentVariablesAccessible;
    }

    @Nullable
    public String getDefaultProjectName() {
        return "default";
    }

    @Nullable
    private String getCommandLineArgument(@NotNull String argName) {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(argName) && args.length > i + 1) {
                return args[i + 1];
            }
            ++i;
        }
        return null;
    }

    @NotNull
    public synchronized List<Path> getDriverLibsLocation(@NotNull String driverId) {
        return Arrays.stream(this.driverLibsLocation.getOrDefault(driverId, new String[0])).map(string -> Path.of(string, new String[0])).collect(Collectors.toList());
    }

    public void addDriverLibsLocation(@NotNull String driverId, @NotNull String[] driverLibsLocation) {
        this.driverLibsLocation.put(driverId, driverLibsLocation);
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return new BundlePreferenceStore("org.jkiss.dbeaver.dpi.app");
    }
}

