/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.parts;

import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class Thumbnail
extends Figure
implements UpdateListener {
    private static final boolean IS_MAC = "cocoa".equals(SWT.getPlatform());
    private boolean isDirty;
    private float scaleX;
    private float scaleY;
    private IFigure sourceFigure;
    Dimension targetSize = new Dimension(0, 0);
    private Image thumbnailImage;
    private Dimension thumbnailImageSize;
    private final ThumbnailUpdater updater = new ThumbnailUpdater();
    private int refreshRate = -1;

    public Thumbnail() {
    }

    public Thumbnail(IFigure fig) {
        this();
        this.setSource(fig);
    }

    private Dimension adjustToAspectRatio(Dimension size, boolean adjustToMaxDimension) {
        int height;
        int width;
        Dimension sourceSize = this.getSourceRectangle().getSize();
        Dimension borderSize = new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight());
        size.expand(borderSize.getNegated());
        if (adjustToMaxDimension) {
            width = Math.max(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.max(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        } else {
            width = Math.min(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.min(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        }
        size.width = width;
        size.height = height;
        return size.expand(borderSize);
    }

    public void deactivate() {
        this.sourceFigure.getUpdateManager().removeUpdateListener(this);
        this.updater.deactivate();
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            return this.adjustToAspectRatio(this.getBounds().getSize(), false);
        }
        Dimension preferredSize = this.adjustToAspectRatio(this.prefSize.getCopy(), true);
        if (this.maxSize == null) {
            return preferredSize;
        }
        Dimension maximumSize = this.adjustToAspectRatio(this.maxSize.getCopy(), true);
        if (preferredSize.contains(maximumSize)) {
            return maximumSize;
        }
        return preferredSize;
    }

    protected float getScaleX() {
        return this.scaleX;
    }

    protected float getScaleY() {
        return this.scaleY;
    }

    protected IFigure getSource() {
        return this.sourceFigure;
    }

    protected Rectangle getSourceRectangle() {
        return this.sourceFigure.getBounds();
    }

    protected Image getThumbnailImage() {
        Dimension oldSize = this.targetSize;
        this.targetSize = this.getPreferredSize();
        this.targetSize.expand(new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight()).negate());
        this.setScales((float)this.targetSize.width / (float)this.getSourceRectangle().width, (float)this.targetSize.height / (float)this.getSourceRectangle().height);
        if (this.isDirty() && !this.updater.isRunning()) {
            this.updater.start();
        } else if (oldSize != null && !this.targetSize.equals(oldSize)) {
            this.revalidate();
            this.updater.restart();
        }
        return this.thumbnailImage;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void notifyPainting(Rectangle damage, Map<IFigure, Rectangle> dirtyRegions) {
        for (IFigure current : dirtyRegions.keySet()) {
            while (current != null) {
                if (current == this.getSource()) {
                    this.setDirty(true);
                    this.repaint();
                    return;
                }
                current = current.getParent();
            }
        }
    }

    @Override
    public void notifyValidating() {
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        Image thumbnail = this.getThumbnailImage();
        if (thumbnail == null) {
            return;
        }
        graphics.drawImage(thumbnail, this.getClientArea().getLocation());
    }

    public void setDirty(boolean value) {
        this.isDirty = value;
    }

    protected void setScales(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
    }

    public void setSource(IFigure fig) {
        if (this.sourceFigure == fig) {
            return;
        }
        if (this.sourceFigure != null) {
            this.sourceFigure.getUpdateManager().removeUpdateListener(this);
        }
        this.sourceFigure = fig;
        if (this.sourceFigure != null) {
            this.setScales((float)this.getSize().width / (float)this.getSourceRectangle().width, (float)this.getSize().height / (float)this.getSourceRectangle().height);
            this.sourceFigure.getUpdateManager().addUpdateListener(this);
            this.repaint();
        }
    }

    protected Dimension getTargetSize() {
        return this.targetSize;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    class ThumbnailUpdater
    implements Runnable {
        private static final int MIN_TILE_SIZE = 256;
        private static final int MAX_NUMBER_OF_TILES = 16;
        private int currentHTile;
        private int currentVTile;
        private int hTiles;
        private int vTiles;
        private Dimension tileSize;
        private Dimension sourceSize;
        private boolean isActive = true;
        private boolean isRunning = false;
        private Image tileImage;
        private Dimension tileImageSize;
        private GC tileGC;
        private SWTGraphics tileGraphics;
        private GC thumbnailGC;

        ThumbnailUpdater() {
        }

        public void deactivate() {
            this.setActive(false);
            this.stop();
            if (Thumbnail.this.thumbnailImage != null) {
                Thumbnail.this.thumbnailImage.dispose();
                Thumbnail.this.thumbnailImage = null;
                Thumbnail.this.thumbnailImageSize = null;
            }
        }

        protected int getCurrentHTile() {
            return this.currentHTile;
        }

        protected int getCurrentVTile() {
            return this.currentVTile;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void resetTileValues() {
            this.sourceSize = Thumbnail.this.getSourceRectangle().getSize();
            this.hTiles = Math.min((int)Math.ceil((float)this.sourceSize.width / 256.0f), 16);
            this.vTiles = Math.min((int)Math.ceil((float)this.sourceSize.height / 256.0f), 16);
            this.tileSize = new Dimension((int)Math.ceil((float)this.sourceSize.width / (float)this.hTiles), (int)Math.ceil((float)this.sourceSize.height / (float)this.vTiles));
            this.currentHTile = 0;
            this.currentVTile = 0;
        }

        public void restart() {
            this.stop();
            this.start();
        }

        @Override
        public void run() {
            if (!this.isActive() || !this.isRunning() || this.tileGraphics == null) {
                return;
            }
            int v = this.getCurrentVTile();
            int sy1 = v * this.tileSize.height;
            int sy2 = Math.min((v + 1) * this.tileSize.height, this.sourceSize.height);
            int h = this.getCurrentHTile();
            int sx1 = h * this.tileSize.width;
            int sx2 = Math.min((h + 1) * this.tileSize.width, this.sourceSize.width);
            if (IS_MAC) {
                this.createTileGraphics();
            }
            this.tileGraphics.pushState();
            Rectangle rect = new Rectangle(0, 0, sx2 - sx1, sy2 - sy1);
            this.tileGraphics.fillRectangle(rect);
            Point p = Thumbnail.this.getSourceRectangle().getLocation();
            this.tileGraphics.translate((float)(-p.x) * Thumbnail.this.getScaleX() - (float)sx1, (float)(-p.y) * Thumbnail.this.getScaleY() - (float)sy1);
            this.tileGraphics.scale(Thumbnail.this.getScaleX());
            Thumbnail.this.sourceFigure.paint(this.tileGraphics);
            this.tileGraphics.popState();
            this.thumbnailGC.drawImage(this.tileImage, 0, 0, sx2 - sx1, sy2 - sy1, sx1, sy1, sx2 - sx1, sy2 - sy1);
            if (this.getCurrentHTile() < this.hTiles - 1) {
                this.setCurrentHTile(this.getCurrentHTile() + 1);
            } else {
                this.setCurrentHTile(0);
                if (this.getCurrentVTile() < this.vTiles - 1) {
                    this.setCurrentVTile(this.getCurrentVTile() + 1);
                } else {
                    this.setCurrentVTile(0);
                }
            }
            if (this.getCurrentHTile() != 0 || this.getCurrentVTile() != 0) {
                Display.getCurrent().asyncExec((Runnable)this);
            } else if (Thumbnail.this.isDirty()) {
                Thumbnail.this.setDirty(false);
                Display.getCurrent().asyncExec((Runnable)this);
                Thumbnail.this.repaint();
            } else {
                this.stop();
                Thumbnail.this.repaint();
            }
        }

        public void setActive(boolean value) {
            this.isActive = value;
        }

        protected void setCurrentHTile(int count) {
            this.currentHTile = count;
        }

        protected void setCurrentVTile(int count) {
            this.currentVTile = count;
        }

        public void start() {
            if (!this.isActive() || this.isRunning()) {
                return;
            }
            this.isRunning = true;
            Thumbnail.this.setDirty(false);
            this.resetTileValues();
            if (!Thumbnail.this.targetSize.equals(Thumbnail.this.thumbnailImageSize)) {
                this.resetThumbnailImage();
            }
            if (Thumbnail.this.targetSize.isEmpty()) {
                return;
            }
            this.thumbnailGC = new GC((Drawable)Thumbnail.this.thumbnailImage, 0);
            if (!this.tileSize.equals(this.tileImageSize)) {
                this.resetTileImage();
            }
            this.createTileGraphics();
            Thumbnail.this.setScales((float)Thumbnail.this.targetSize.width / (float)this.sourceSize.width, (float)Thumbnail.this.targetSize.height / (float)this.sourceSize.height);
            if (Thumbnail.this.refreshRate <= 0) {
                Display.getCurrent().asyncExec((Runnable)this);
            } else {
                Display.getCurrent().timerExec(Thumbnail.this.refreshRate, (Runnable)this);
            }
        }

        private void createTileGraphics() {
            if (this.tileGC != null && !this.tileGC.isDisposed()) {
                this.tileGC.dispose();
            }
            this.tileGC = new GC((Drawable)this.tileImage, Thumbnail.this.sourceFigure.isMirrored() ? 0x4000000 : 0);
            if (this.tileGraphics != null) {
                this.tileGraphics.dispose();
            }
            this.tileGraphics = new SWTGraphics(this.tileGC);
            Color color = Thumbnail.this.sourceFigure.getForegroundColor();
            if (color != null) {
                this.tileGraphics.setForegroundColor(color);
            }
            if ((color = Thumbnail.this.sourceFigure.getBackgroundColor()) != null) {
                this.tileGraphics.setBackgroundColor(color);
            }
            this.tileGraphics.setFont(Thumbnail.this.sourceFigure.getFont());
        }

        private void resetThumbnailImage() {
            if (Thumbnail.this.thumbnailImage != null) {
                Thumbnail.this.thumbnailImage.dispose();
            }
            if (!Thumbnail.this.targetSize.isEmpty()) {
                Thumbnail.this.thumbnailImage = new Image((Device)Display.getDefault(), Thumbnail.this.targetSize.width, Thumbnail.this.targetSize.height);
                Thumbnail.this.thumbnailImageSize = new Dimension(Thumbnail.this.targetSize);
            } else {
                Thumbnail.this.thumbnailImage = null;
                Thumbnail.this.thumbnailImageSize = new Dimension(0, 0);
            }
        }

        private void resetTileImage() {
            if (this.tileImage != null) {
                this.tileImage.dispose();
            }
            if (!this.tileSize.isEmpty()) {
                this.tileImage = new Image((Device)Display.getDefault(), this.tileSize.width, this.tileSize.height);
                this.tileImageSize = new Dimension(this.tileSize);
            } else {
                this.tileImage = null;
                this.tileImageSize = new Dimension(0, 0);
            }
        }

        public void stop() {
            this.isRunning = false;
            if (this.tileGraphics != null) {
                this.tileGraphics.dispose();
                this.tileGraphics = null;
            }
            if (this.tileGC != null) {
                this.tileGC.dispose();
                this.tileGC = null;
            }
            if (this.thumbnailGC != null) {
                this.thumbnailGC.dispose();
                this.thumbnailGC = null;
            }
            if (this.tileImage != null) {
                this.tileImage.dispose();
                this.tileImage = null;
                this.tileImageSize = null;
            }
        }
    }
}

