/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AIContextSettings {
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    @NotNull
    protected PersistentSettings settings = new PersistentSettings();

    @Nullable
    public abstract DBPDataSourceContainer getDataSourceContainer();

    public abstract void saveSettings() throws DBException;

    public boolean isMetaTransferConfirmed() {
        return this.settings.confirmed;
    }

    public void setMetaTransferConfirmed(boolean metaTransferConfirmed) {
        this.settings.confirmed = metaTransferConfirmed;
    }

    @Nullable
    public AIDatabaseScope getScope() {
        return this.settings.scope;
    }

    public void setScope(AIDatabaseScope scope) {
        this.settings.scope = scope;
    }

    @Nullable
    public String[] getCustomObjectIds() {
        return this.settings.objects;
    }

    public void setCustomObjectIds(String[] customObjectIds) {
        this.settings.objects = customObjectIds;
    }

    public void loadSettingsFromMap(Map<String, Object> dsConfig) {
        this.settings = (PersistentSettings)GSON.fromJson(GSON.toJsonTree(dsConfig), PersistentSettings.class);
        if (this.settings.objects != null) {
            this.settings.objects = (String[])Arrays.stream(this.settings.objects).filter(o -> !CommonUtils.isEmpty((String)o)).toArray(String[]::new);
        }
    }

    public void loadSettingsFromString(String dsConfig) {
        this.loadSettingsFromMap((Map)GSON.fromJson(dsConfig, JSONUtils.MAP_TYPE_TOKEN));
    }

    public Map<String, Object> saveSettingsToMap() {
        return (Map)GSON.fromJson(GSON.toJson((Object)this.settings), JSONUtils.MAP_TYPE_TOKEN);
    }

    public String saveSettingsToString() {
        return GSON.toJson(this.saveSettingsToMap());
    }

    public boolean equalsSettings(AIContextSettings that) {
        return this.settings.confirmed == that.settings.confirmed && this.settings.scope == that.settings.scope && Objects.deepEquals(this.settings.objects, that.settings.objects);
    }

    protected static class PersistentSettings {
        public boolean confirmed;
        public AIDatabaseScope scope;
        public String[] objects;

        protected PersistentSettings() {
        }
    }
}

