/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.internal.ide.dialogs.ResourceComparator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.IProgressConstants2;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CleanDialog
extends MessageDialog {
    private static final String DIALOG_SETTINGS_SECTION = "CleanDialogSettings";
    private static final String TOGGLE_SELECTED = "TOGGLE_SELECTED";
    private static final String BUILD_NOW = "BUILD_NOW";
    private static final String BUILD_ALL = "BUILD_ALL";
    private Button alwaysCleanButton;
    private Button buildNowButton;
    private Button globalBuildButton;
    private Button projectBuildButton;
    private CheckboxTableViewer projectNames;
    private Object[] selection;
    private IWorkbenchWindow window;
    private Text filterText;
    private SearchPattern searchPattern = new SearchPattern();

    private static String getQuestion() {
        boolean autoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        if (autoBuilding) {
            return IDEWorkbenchMessages.CleanDialog_buildCleanAuto;
        }
        return IDEWorkbenchMessages.CleanDialog_buildCleanManual;
    }

    public CleanDialog(IWorkbenchWindow window, IProject[] selection) {
        super(window.getShell(), IDEWorkbenchMessages.CleanDialog_title, null, CleanDialog.getQuestion(), 0, 0, new String[]{IDEWorkbenchMessages.CleanDialog_clean_button_label, IDialogConstants.CANCEL_LABEL});
        this.window = window;
        this.selection = selection;
        if (this.selection == null) {
            this.selection = new Object[0];
        }
        this.searchPattern.setPattern("");
    }

    protected void buttonPressed(int buttonId) {
        final boolean cleanAll = this.alwaysCleanButton.getSelection();
        final boolean buildAll = this.buildNowButton != null && this.buildNowButton.getSelection();
        final boolean globalBuild = this.globalBuildButton != null && this.globalBuildButton.getSelection();
        super.buttonPressed(buttonId);
        if (buttonId != 0) {
            return;
        }
        BuildUtilities.saveEditors(null);
        WorkspaceJob cleanJob = new WorkspaceJob(cleanAll ? IDEWorkbenchMessages.CleanDialog_cleanAllTaskName : IDEWorkbenchMessages.CleanDialog_cleanSelectedTaskName){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                CleanDialog.this.doClean(cleanAll, monitor);
                if (buildAll) {
                    if (globalBuild) {
                        GlobalBuildAction build = new GlobalBuildAction(CleanDialog.this.window, 10);
                        build.doBuild();
                    } else {
                        IProject[] projects = new IProject[CleanDialog.this.selection.length];
                        int i = 0;
                        while (i < CleanDialog.this.selection.length) {
                            projects[i] = (IProject)CleanDialog.this.selection[i];
                            ++i;
                        }
                        ProjectSubsetBuildAction projectBuild = new ProjectSubsetBuildAction((IShellProvider)CleanDialog.this.window, 10, projects);
                        projectBuild.runInBackground(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        cleanJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        cleanJob.setUser(true);
        cleanJob.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        cleanJob.schedule();
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout();
        areaLayout.marginHeight = 0;
        areaLayout.marginWidth = 0;
        areaLayout.numColumns = 1;
        areaLayout.makeColumnsEqualWidth = false;
        area.setLayout((Layout)areaLayout);
        area.setLayoutData((Object)new GridData(1808));
        IDialogSettings settings = this.getDialogSettings();
        this.alwaysCleanButton = new Button(area, 32);
        this.alwaysCleanButton.setText(IDEWorkbenchMessages.CleanDialog_alwaysCleanAllButton);
        this.alwaysCleanButton.setSelection(!settings.getBoolean(TOGGLE_SELECTED));
        this.alwaysCleanButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateEnablement();
            if (!this.alwaysCleanButton.getSelection()) {
                this.setInitialFilterText();
            } else {
                this.filterText.setText("");
            }
        }));
        this.filterText = new Text(area, 2436);
        this.filterText.setMessage(IDEWorkbenchMessages.CleanDialog_typeFilterText);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.filterText.setLayoutData((Object)gd);
        this.filterText.addModifyListener(e -> {
            String filter = this.filterText.getText();
            if (filter.startsWith("*") || filter.startsWith("?")) {
                this.searchPattern.setPattern(filter);
            } else {
                this.searchPattern.setPattern("*" + filter);
            }
            if (filter.isEmpty()) {
                this.filterText.setMessage(IDEWorkbenchMessages.CleanDialog_typeFilterText);
            }
            this.projectNames.refresh();
        });
        this.filterText.addFocusListener(FocusListener.focusLostAdapter(e -> {
            if (this.filterText.getText().equals(IDEWorkbenchMessages.CleanDialog_typeFilterText)) {
                this.filterText.setText("");
            }
        }));
        this.createProjectSelectionTable(area);
        if (!this.alwaysCleanButton.getSelection()) {
            this.setInitialFilterText();
        }
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            SelectionListener updateEnablement = SelectionListener.widgetSelectedAdapter(e -> this.updateEnablement());
            this.buildNowButton = new Button(parent, 32);
            this.buildNowButton.setText(IDEWorkbenchMessages.CleanDialog_buildNowButton);
            String buildNow = settings.get(BUILD_NOW);
            this.buildNowButton.setSelection(buildNow == null || Boolean.parseBoolean(buildNow));
            this.buildNowButton.setLayoutData((Object)new GridData(32));
            this.buildNowButton.addSelectionListener(updateEnablement);
            this.globalBuildButton = new Button(parent, 16);
            this.globalBuildButton.setText(IDEWorkbenchMessages.CleanDialog_globalBuildButton);
            String buildAll = settings.get(BUILD_ALL);
            this.globalBuildButton.setSelection(buildAll == null || Boolean.parseBoolean(buildAll));
            GridData data = new GridData(32);
            data.horizontalIndent = 10;
            this.globalBuildButton.setLayoutData((Object)data);
            this.globalBuildButton.setEnabled(this.buildNowButton.getSelection());
            this.projectBuildButton = new Button(parent, 16);
            this.projectBuildButton.setText(IDEWorkbenchMessages.CleanDialog_buildSelectedProjectsButton);
            this.projectBuildButton.setSelection(!this.globalBuildButton.getSelection());
            data = new GridData(32);
            data.horizontalIndent = 10;
            this.projectBuildButton.setLayoutData((Object)data);
            this.projectBuildButton.setEnabled(this.buildNowButton.getSelection());
            SelectionListener buildRadioSelected = SelectionListener.widgetSelectedAdapter(e -> this.updateBuildRadioEnablement());
            this.globalBuildButton.addSelectionListener(buildRadioSelected);
            this.projectBuildButton.addSelectionListener(buildRadioSelected);
        }
        return area;
    }

    private void setInitialFilterText() {
        this.filterText.setText(IDEWorkbenchMessages.CleanDialog_typeFilterText);
        this.filterText.selectAll();
        this.filterText.setFocus();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateEnablement();
        return contents;
    }

    private void checkAllItemsIfSelectAllEventIsFired(SelectionEvent e) {
        if (e.item == null) {
            this.projectNames.setAllChecked(true);
            this.checkStateChanged();
        }
    }

    private void createProjectSelectionTable(Composite parent) {
        this.projectNames = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.projectNames.getTable().addSelectionListener(SelectionListener.widgetSelectedAdapter(this::checkAllItemsIfSelectAllEventIsFired));
        this.projectNames.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.projectNames.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectNames.setComparator((ViewerComparator)new ResourceComparator(1));
        this.projectNames.addFilter(new ViewerFilter(){
            private final IProject[] projectHolder = new IProject[1];

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IProject)) {
                    return false;
                }
                IProject project = (IProject)element;
                boolean isProjectNameMatchingPattern = CleanDialog.this.searchPattern.matches(project.getName());
                if (!(project.isAccessible() && isProjectNameMatchingPattern || CleanDialog.this.filterText.getText().equals(IDEWorkbenchMessages.CleanDialog_typeFilterText))) {
                    return false;
                }
                this.projectHolder[0] = project;
                return BuildUtilities.isEnabled(this.projectHolder, 15);
            }
        });
        this.projectNames.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.projectNames.getTable().setLayoutData((Object)data);
        this.projectNames.setCheckedElements(this.selection);
        Object[] checked = this.projectNames.getCheckedElements();
        if (checked.length > 0) {
            this.projectNames.reveal(checked[0]);
        }
        this.projectNames.addCheckStateListener(event -> this.checkStateChanged());
    }

    private void checkStateChanged() {
        this.selection = this.projectNames.getCheckedElements();
        this.updateEnablement();
    }

    protected void doClean(boolean cleanAll, IProgressMonitor monitor) throws CoreException {
        if (cleanAll) {
            ResourcesPlugin.getWorkspace().build(15, monitor);
        } else {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)IDEWorkbenchMessages.CleanDialog_cleanSelectedTaskName, (int)this.selection.length);
            Object[] objectArray = this.selection;
            int n = this.selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object currentSelection = objectArray[n2];
                ((IProject)currentSelection).build(15, (IProgressMonitor)subMonitor.split(1));
                ++n2;
            }
        }
    }

    protected void updateEnablement() {
        this.projectNames.getTable().setEnabled(!this.alwaysCleanButton.getSelection());
        this.filterText.setEnabled(!this.alwaysCleanButton.getSelection());
        boolean enabled = this.selection.length > 0 || this.alwaysCleanButton.getSelection();
        this.getButton(0).setEnabled(enabled);
        if (this.globalBuildButton != null) {
            this.globalBuildButton.setEnabled(this.buildNowButton.getSelection());
        }
        if (this.projectBuildButton != null) {
            this.projectBuildButton.setEnabled(this.buildNowButton.getSelection());
        }
    }

    protected void updateBuildRadioEnablement() {
        this.projectBuildButton.setSelection(!this.globalBuildButton.getSelection());
    }

    public boolean close() {
        this.persistDialogSettings();
        return super.close();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)FrameworkUtil.getBundle(CleanDialog.class)).getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    private void persistDialogSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.buildNowButton != null) {
            settings.put(BUILD_NOW, this.buildNowButton.getSelection());
        }
        if (this.globalBuildButton != null) {
            settings.put(BUILD_ALL, this.globalBuildButton.getSelection());
        }
        settings.put(TOGGLE_SELECTED, !this.alwaysCleanButton.getSelection());
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    private static class ProjectSubsetBuildAction
    extends BuildAction {
        private IProject[] projectsToBuild = new IProject[0];

        public ProjectSubsetBuildAction(IShellProvider shellProvider, int type, IProject[] projects) {
            super(shellProvider, type);
            this.projectsToBuild = projects;
        }

        @Override
        protected List<? extends IResource> getSelectedResources() {
            return Arrays.asList(this.projectsToBuild);
        }
    }
}

