/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.FeatureSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class TipsAndTricksAction
extends PartEventAction
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public TipsAndTricksAction(IWorkbenchWindow window) {
        super(IDEWorkbenchMessages.TipsAndTricks_text);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setToolTipText(IDEWorkbenchMessages.TipsAndTricks_toolTip);
        window.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.tips_and_tricks_action_context");
        this.setActionDefinitionId("org.eclipse.ui.help.tipsAndTricksAction");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_TIPS_AND_TRICKS"));
        this.workbenchWindow.getPartService().addPartListener((IPartListener)this);
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        AboutInfo[] featureInfos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        ArrayList<AboutInfo> tipsAndTricksFeatures = new ArrayList<AboutInfo>(featureInfos.length);
        AboutInfo[] aboutInfoArray = featureInfos;
        int n = featureInfos.length;
        int n2 = 0;
        while (n2 < n) {
            AboutInfo featureInfo = aboutInfoArray[n2];
            if (featureInfo.getTipsAndTricksHref() != null) {
                tipsAndTricksFeatures.add(featureInfo);
            }
            ++n2;
        }
        Shell shell = this.workbenchWindow.getShell();
        if (tipsAndTricksFeatures.isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)IDEWorkbenchMessages.TipsAndTricksMessageDialog_title, (String)IDEWorkbenchMessages.TipsAndTricksMessageDialog_message);
            return;
        }
        AboutInfo[] features = new AboutInfo[tipsAndTricksFeatures.size()];
        tipsAndTricksFeatures.toArray(features);
        IProduct product = Platform.getProduct();
        FeatureSelectionDialog d = new FeatureSelectionDialog(shell, features, product == null ? null : product.getId(), IDEWorkbenchMessages.TipsAndTricksPageSelectionDialog_title, IDEWorkbenchMessages.TipsAndTricksPageSelectionDialog_message, "org.eclipse.ui.ide.tips_and_tricks_page_selection_dialog");
        d.create();
        if (d.open() != 0 || d.getResult().size() != 1) {
            return;
        }
        AboutInfo feature = d.getFirstResult().orElse(null);
        if (feature != null) {
            String href = feature.getTipsAndTricksHref();
            if (href != null) {
                BusyIndicator.showWhile((Display)shell.getDisplay(), () -> this.workbenchWindow.getWorkbench().getHelpSystem().displayHelpResource(href));
            } else {
                Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, null);
                ErrorDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.TipsAndTricksErrorDialog_title, (String)IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, (IStatus)status);
            }
        } else {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, null);
            ErrorDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.TipsAndTricksErrorDialog_title, (String)IDEWorkbenchMessages.TipsAndTricksErrorDialog_noFeatures, (IStatus)status);
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow.getPartService().removePartListener((IPartListener)this);
        this.workbenchWindow = null;
    }
}

