/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core;

import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.text.quicksearch.internal.core.priority.DefaultPriorityFunction;
import org.eclipse.text.quicksearch.internal.core.priority.PriorityFunction;
import org.eclipse.text.quicksearch.internal.ui.Messages;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;

public abstract class ResourceWalker
extends Job {
    private final Set<QItem> filesToSearch = ConcurrentHashMap.newKeySet();
    private volatile boolean suspend = false;
    private PriorityFunction prioritFun = new DefaultPriorityFunction();

    public ResourceWalker() {
        super(Messages.QuickSearchDialog_title);
        this.init();
    }

    protected void init() {
        this.filesToSearch.clear();
        this.addRecursive(this.filesToSearch, new QItem(0.0, (IResource)ResourcesPlugin.getWorkspace().getRoot()));
    }

    private void addRecursive(Collection<QItem> queue, QItem item) {
        IContainer f;
        IResource r = item.resource;
        if (r instanceof IFile) {
            queue.add(item);
        } else if (r instanceof IContainer && (f = (IContainer)r).isAccessible()) {
            try {
                IResource[] iResourceArray = f.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    double p = this.priority(child);
                    if (p != Double.NEGATIVE_INFINITY) {
                        this.addRecursive(queue, new QItem(p, child));
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                QuickSearchActivator.log(e);
            }
        }
    }

    public boolean isDone() {
        return this.filesToSearch.isEmpty();
    }

    public void suspend() {
        this.suspend = true;
    }

    public void stop() {
        this.filesToSearch.clear();
        this.suspend = false;
    }

    public void resume() {
        if (this.isDone()) {
            return;
        }
        this.suspend = false;
        this.schedule();
    }

    public IStatus run(IProgressMonitor monitor) {
        int workers = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        ExecutorService executorService = Executors.newFixedThreadPool(workers);
        PriorityQueue<QItem> queue = new PriorityQueue<QItem>();
        queue.addAll(this.filesToSearch);
        int worker = 0;
        while (worker < workers) {
            executorService.submit(() -> {
                QItem item;
                while ((item = (QItem)queue.poll()) != null) {
                    if (monitor.isCanceled() || this.suspend) break;
                    IResource r = item.resource;
                    IFile f = (IFile)r;
                    boolean searched = this.searchIn(f, () -> monitor.isCanceled() || this.suspend);
                    if (!searched) continue;
                    this.filesToSearch.remove(item);
                }
            });
            ++worker;
        }
        try {
            while (!executorService.awaitTermination(1L, TimeUnit.MILLISECONDS)) {
                executorService.shutdown();
                if (!monitor.isCanceled() && !this.suspend) continue;
                queue.clear();
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.suspend) {
            this.filesToSearch.clear();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected abstract boolean searchIn(IFile var1, BooleanSupplier var2);

    final double priority(IResource r) {
        return this.prioritFun.priority(r);
    }

    public void setPriorityFun(PriorityFunction f) {
        Assert.isNotNull((Object)f, (String)"PriorityFunction should never be null");
        this.prioritFun = f;
    }

    private record QItem(double priority, IResource resource) implements Comparable<QItem>
    {
        @Override
        public int compareTo(QItem other) {
            return Double.compare(other.priority, this.priority);
        }
    }
}

