/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.session;

import java.sql.ResultSet;
import java.util.Date;
import java.util.Objects;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class SQLServerSession
extends AbstractServerSession {
    private static final String CAT_CLIENT = "Client";
    private static final String CAT_TIMING = "Timings";
    private final long id;
    private Date loginTime;
    private Date lastRequestStart;
    private Date lastRequestEnd;
    private String hostName;
    private String programName;
    private String hostPID;
    private String clientVersion;
    private String clientInterface;
    private String loginName;
    private String ntDomain;
    private String ntUserName;
    private String command;
    private String status;
    private long cpuTime;
    private long memoryUsage;
    private long totalScheduledTime;
    private long totalElapsedTime;
    private long readsNum;
    private long writesNum;
    private String language;
    private long rowCount;
    private final String databaseName;
    private String sqlText;

    public SQLServerSession(ResultSet dbResult) {
        this.id = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"session_id");
        this.loginTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"login_time");
        this.lastRequestStart = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"last_request_start_time");
        this.lastRequestEnd = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"last_request_end_time");
        this.hostName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"host_name");
        this.programName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"program_name");
        this.hostPID = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"host_process_id");
        this.clientVersion = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_version");
        this.clientInterface = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"client_interface_name");
        this.loginName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"login_name");
        this.ntDomain = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"nt_domain");
        this.ntUserName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"nt_user_name");
        this.status = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"status");
        this.command = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"command");
        this.cpuTime = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"cpu_time");
        this.memoryUsage = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"memory_usage");
        this.totalScheduledTime = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"total_scheduled_time");
        this.totalElapsedTime = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"total_elapsed_time");
        this.readsNum = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"reads");
        this.writesNum = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"writes");
        this.language = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"language");
        this.rowCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"row_count");
        this.databaseName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"database_name");
        this.sqlText = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sql_text");
    }

    @Property(viewable=true, order=1)
    public long getId() {
        return this.id;
    }

    @Property(viewable=false, category="Client", order=5)
    public String getCommand() {
        return this.command;
    }

    @Property(viewable=true, order=6)
    public String getStatus() {
        return this.status;
    }

    @Property(viewable=false, category="Timings", order=10)
    public Date getLoginTime() {
        return this.loginTime;
    }

    @Property(viewable=false, category="Timings", order=11)
    public Date getLastRequestStart() {
        return this.lastRequestStart;
    }

    @Property(viewable=false, category="Timings", order=12)
    public Date getLastRequestEnd() {
        return this.lastRequestEnd;
    }

    @Property(viewable=false, category="Client", order=20)
    public String getHostName() {
        return this.hostName;
    }

    @Property(viewable=true, category="Client", order=21)
    public String getProgramName() {
        return this.programName;
    }

    @Property(viewable=true, category="Client", order=22)
    public String getHostPID() {
        return this.hostPID;
    }

    @Property(viewable=false, category="Client", order=23)
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Property(viewable=false, category="Client", order=24)
    public String getClientInterface() {
        return this.clientInterface;
    }

    @Property(viewable=true, category="Client", order=25)
    public String getLoginName() {
        return this.loginName;
    }

    @Property(viewable=true, category="Client", order=26)
    public String getNtDomain() {
        return this.ntDomain;
    }

    @Property(viewable=false, category="Client", order=27)
    public String getNtUserName() {
        return this.ntUserName;
    }

    @Property(viewable=true, category="Statistics", order=40)
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Property(viewable=true, category="Statistics", order=41)
    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    @Property(viewable=false, category="Statistics", order=42)
    public long getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @Property(viewable=false, category="Statistics", order=43)
    public long getTotalElapsedTime() {
        return this.totalElapsedTime;
    }

    @Property(viewable=true, category="Statistics", order=44)
    public long getReadsNum() {
        return this.readsNum;
    }

    @Property(viewable=true, category="Statistics", order=45)
    public long getWritesNum() {
        return this.writesNum;
    }

    @Property(viewable=false, category="Statistics", order=46)
    public long getRowCount() {
        return this.rowCount;
    }

    @Property(viewable=false, category="Client", order=31)
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Property(viewable=false, category="Client", order=32)
    public String getLanguage() {
        return this.language;
    }

    @Property(viewable=false, order=9)
    public String getActiveQuery() {
        return this.sqlText;
    }

    public String getSessionId() {
        return String.valueOf(this.id);
    }

    public String toString() {
        if (this.databaseName != null) {
            return this.id + "@" + this.databaseName;
        }
        return String.valueOf(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SQLServerSession that = (SQLServerSession)((Object)o);
        return this.id == that.id && Objects.equals(this.databaseName, that.databaseName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.databaseName);
    }
}

