/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolScript;
import org.jkiss.dbeaver.ext.exasol.model.ExasolVirtualSchemaParameter;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class ExasolVirtualSchema
extends ExasolSchema {
    private String adapterScriptSchema;
    private String adapterScriptName;
    private Timestamp lastRefresh;
    private String adapterNotes;
    private String refreshBy;
    private ExasolDataSource dataSource;
    private DBSObjectCache<ExasolVirtualSchema, ExasolVirtualSchemaParameter> virtualSchemaParameterCache;

    public ExasolVirtualSchema(ExasolDataSource exasolDataSource, ResultSet dbResult) throws DBException {
        super(exasolDataSource, dbResult);
        this.adapterNotes = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ADAPTER_NOTES");
        this.lastRefresh = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REFRESH");
        this.refreshBy = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LAST_REFRESH_BY");
        List fqnAdapter = CommonUtils.splitString((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ADAPTER_SCRIPT"), (char)'.');
        this.adapterScriptSchema = (String)fqnAdapter.get(0);
        this.adapterScriptName = (String)fqnAdapter.get(1);
        this.dataSource = exasolDataSource;
        this.virtualSchemaParameterCache = new JDBCObjectSimpleCache(ExasolVirtualSchemaParameter.class, "/*snapshot execution*/ select\r\n\tproperty_name,\r\n\tproperty_value\r\nfrom\r\n\tEXA_ALL_VIRTUAL_SCHEMA_PROPERTIES\r\nwhere\r\n\tschema_name = ?\r\norder by\r\n\tproperty_name\r\n", new Object[]{super.getName()});
    }

    @Property(viewable=true, order=10)
    public ExasolSchema getAdapterScriptSchema() throws DBException {
        return this.dataSource.getSchema((DBRProgressMonitor)new VoidProgressMonitor(), this.adapterScriptSchema);
    }

    @Property(viewable=true, order=20)
    public ExasolScript getAdapterScriptName() throws DBException {
        return this.getAdapterScriptSchema().getProcedure((DBRProgressMonitor)new VoidProgressMonitor(), this.adapterScriptName);
    }

    @Property(viewable=true, order=30)
    public Timestamp getLastRefresh() {
        return this.lastRefresh;
    }

    @Property(viewable=true, order=40)
    public String getRefreshBy() {
        return this.refreshBy;
    }

    @Override
    public ExasolDataSource getDataSource() {
        return this.dataSource;
    }

    public Collection<ExasolVirtualSchemaParameter> getVirtualSchemaParameters() throws DBException {
        return this.virtualSchemaParameterCache.getAllObjects((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)this);
    }

    @Override
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return this.adapterNotes.replaceAll(",", ",\n");
    }

    @Override
    public Boolean isPhysicalSchema() {
        return false;
    }
}

