/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class ExasolPrimaryKeyManager
extends SQLConstraintManager<ExasolTableUniqueKey, ExasolTable>
implements DBEObjectRenamer<ExasolTableUniqueKey> {
    public DBSObjectCache<? extends DBSObject, ExasolTableUniqueKey> getObjectsCache(ExasolTableUniqueKey object) {
        return object.getTable().getSchema().getConstraintCache();
    }

    protected ExasolTableUniqueKey createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return new ExasolTableUniqueKey((ExasolTable)container, DBSEntityConstraintType.PRIMARY_KEY, true, "CONSTRAINT");
    }

    protected String getDropConstraintPattern(ExasolTableUniqueKey constraint) {
        return "ALTER TABLE " + constraint.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL) + " DROP PRIMARY KEY";
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        ExasolTableUniqueKey obj = (ExasolTableUniqueKey)command.getObject();
        try {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create PK", ExasolUtils.getPKDdl(obj, monitor)));
        }
        catch (DBException dBException) {
            log.error((Object)"Could not generated DDL for PK");
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull ExasolTableUniqueKey object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        ExasolTableUniqueKey constraint = (ExasolTableUniqueKey)command.getObject();
        if (command.getProperties().containsKey("enabled")) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter PK", "ALTER TABLE " + constraint.getTable().getFullyQualifiedName(DBPEvaluationContext.DDL) + " MODIFY CONSTRAINT " + constraint.getName() + " " + (constraint.getEnabled() != false ? "ENABLE" : "DISABLE")));
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        ExasolTableUniqueKey key = (ExasolTableUniqueKey)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename PK", "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)key.getTable(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " RENAME CONSTRAINT " + DBUtils.getQuotedIdentifier((DBPDataSource)key.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)key.getDataSource(), (String)command.getNewName())));
    }
}

