/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.osgi.framework.Version;

public class GreengageDataSource
extends GreenplumDataSource {
    public GreengageDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container);
    }

    @Override
    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        if (this.serverVersion != null) {
            this.gpVersion = this.getDatabaseVersion("Greengage Database ([0-9\\.]+)");
            if (this.gpVersion == null) {
                this.gpVersion = this.getDatabaseVersion("Greenplum Database ([0-9\\.]+)");
            }
        }
        if (this.gpVersion == null) {
            this.gpVersion = new Version(4, 2, 0);
        }
    }

    @Nullable
    private Version getDatabaseVersion(@NotNull String versionPattern) {
        Matcher matcher = Pattern.compile(versionPattern).matcher(this.serverVersion);
        if (matcher.find()) {
            return new Version(matcher.group(1));
        }
        return null;
    }
}

