/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBEObjectMaker;
import org.jkiss.dbeaver.model.edit.DBEObjectManager;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSInstanceLazy;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.ObjectPropertyTester;
import org.jkiss.dbeaver.ui.editors.DatabaseNodeEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditor;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseModellerEditor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerProjectCreate;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorView;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class NavigatorHandlerObjectCreateBase
extends NavigatorHandlerObjectBase {
    protected boolean createNewObject(IWorkbenchWindow workbenchWindow, DBNNode element, DBNDatabaseNode copyFrom) {
        return this.createNewObject(workbenchWindow, element, null, copyFrom, false);
    }

    protected boolean createNewObject(IWorkbenchWindow workbenchWindow, DBNNode element, @Nullable Class<?> newObjectType, DBNDatabaseNode copyFrom, boolean isFolder) {
        try {
            DBPDataSource dBPDataSource;
            DBEObjectManager objectManager;
            IEditorInput iEditorInput;
            DBSObject sourceObject;
            DBNNode container = null;
            if (isFolder || element instanceof DBNContainer && !(element instanceof DBNDataSource)) {
                container = element;
            } else {
                DBNNode parentNode = element.getParentNode();
                if (parentNode instanceof DBNContainer) {
                    container = parentNode;
                }
            }
            if (container == null) {
                throw new DBException("Can't detect container for '" + element.getNodeDisplayName() + "'");
            }
            if (container instanceof DBNDatabaseNode && ObjectPropertyTester.isMetadataChangeDisabled((DBNDatabaseNode)container)) {
                throw new DBException("Object create not available in simple view mode");
            }
            if (newObjectType == null) {
                Class childType;
                Class clazz = childType = container instanceof DBNContainer ? ((DBNContainer)container).getChildrenClass() : null;
                if (childType == null) {
                    throw new DBException("Can't determine child element type for container '" + String.valueOf(container) + "'");
                }
                newObjectType = childType;
            }
            if (newObjectType == IProject.class) {
                return NavigatorHandlerProjectCreate.createNewProject(workbenchWindow);
            }
            DBSObject dBSObject = sourceObject = copyFrom == null ? null : copyFrom.getObject();
            Object parentObject = container instanceof DBNDatabaseNode ? ((DBNDatabaseNode)container).getValueObject() : (container instanceof DBNProject ? ((DBNProject)container).getProject() : (container instanceof DBNProjectDatabases ? container.getOwnerProject() : (container instanceof DBNLocalFolder ? ((DBNLocalFolder)container).getFolder() : null)));
            if (container.hasChildren(false) || parentObject instanceof DBSInstanceLazy) {
                try {
                    DBNNode finalContainer = container;
                    UIUtils.runInProgressService(monitor -> {
                        try {
                            if (finalContainer.hasChildren(false)) {
                                finalContainer.getChildren(monitor);
                            }
                            if (parentObject instanceof DBSInstanceLazy) {
                                ((DBSInstanceLazy)parentObject).checkInstanceConnection(monitor);
                            }
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("New object", "Error creating new object", (Throwable)e);
                }
                catch (InterruptedException interruptedException) {}
            }
            DBNDatabaseNode editorNode = null;
            IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
            if (workbenchWindow.getActivePage().getActivePart() == activeEditor && activeEditor.getAdapter(IDatabaseModellerEditor.class) != null && ((IDatabaseModellerEditor)activeEditor.getAdapter(IDatabaseModellerEditor.class)).isModelEditEnabled() && (iEditorInput = activeEditor.getEditorInput()) instanceof IDatabaseEditorInput) {
                IDatabaseEditorInput editorInput = (IDatabaseEditorInput)iEditorInput;
                editorNode = editorInput.getNavigatorNode();
            }
            if ((objectManager = DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(newObjectType)) == null) {
                throw new DBException("Object manager not found for type '" + newObjectType.getName() + "'");
            }
            DBEObjectMaker objectMaker = (DBEObjectMaker)objectManager;
            if (container instanceof DBNDatabaseNode) {
                DBNDatabaseNode dbNode = (DBNDatabaseNode)container;
                dBPDataSource = dbNode.getDataSource();
            } else {
                dBPDataSource = null;
            }
            DBPDataSource dataSource = dBPDataSource;
            boolean openEditor = dataSource != null && (objectMaker.getMakerOptions(dataSource) & 4L) != 0L;
            NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectCreateBase.getCommandTarget(workbenchWindow, container, editorNode, newObjectType, openEditor);
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("container", container);
            options.put("objectType", newObjectType);
            options.put("activeEditor", activeEditor);
            this.createDatabaseObject(commandTarget, objectMaker, parentObject instanceof DBPObject ? (DBPObject)parentObject : null, sourceObject, options);
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Create object", null, e);
            return false;
        }
        return true;
    }

    private <OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBPObject> void createDatabaseObject(NavigatorHandlerObjectBase.CommandTarget commandTarget, DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker, CONTAINER_TYPE parentObject, DBSObject sourceObject, Map<String, Object> options) throws DBException {
        ObjectCreator<OBJECT_TYPE, CONTAINER_TYPE> objectCreator = new ObjectCreator<OBJECT_TYPE, CONTAINER_TYPE>(objectMaker, commandTarget, parentObject, sourceObject, options);
        try {
            UIUtils.runInProgressService(objectCreator);
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("New object", "Error creating new object", (Throwable)e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (objectCreator.newObject == null) {
            return;
        }
        CreateJob<OBJECT_TYPE, CONTAINER_TYPE> job = new CreateJob<OBJECT_TYPE, CONTAINER_TYPE>(commandTarget, objectMaker, parentObject, sourceObject, objectCreator.newObject);
        job.schedule();
    }

    static class CreateJob<OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBPObject>
    extends AbstractJob {
        private final NavigatorHandlerObjectBase.CommandTarget commandTarget;
        private final DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker;
        private final CONTAINER_TYPE parentObject;
        private final DBSObject sourceObject;
        private OBJECT_TYPE newObject;
        private DBNDatabaseNode newNode = null;

        public CreateJob(NavigatorHandlerObjectBase.CommandTarget commandTarget, DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker, CONTAINER_TYPE parentObject, DBSObject sourceObject, OBJECT_TYPE newObject) {
            super("Create new database object with " + objectMaker.getClass().getSimpleName());
            this.setUser(true);
            this.setSystem(false);
            this.commandTarget = commandTarget;
            this.objectMaker = objectMaker;
            this.parentObject = parentObject;
            this.sourceObject = sourceObject;
            this.newObject = newObject;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (this.newObject == null) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask("Save " + this.newObject.getClass().getSimpleName(), 3);
            try {
                if (this.parentObject instanceof DBSObject && (this.objectMaker.getMakerOptions(((DBSObject)this.parentObject).getDataSource()) & 1L) != 0L) {
                    monitor.subTask("Save object");
                    this.commandTarget.getContext().saveChanges(monitor, DBPScriptObject.EMPTY_OPTIONS);
                    monitor.worked(2);
                    if (this.newObject instanceof DBPRefreshableObject) {
                        monitor.subTask("Load object from server");
                        DBNDatabaseNode newChild = DBWorkbench.getPlatform().getNavigatorModel().findNode(this.newObject);
                        if (newChild != null) {
                            newChild.refreshNode(monitor, (Object)this);
                            this.newObject = newChild.getObject();
                        }
                        monitor.worked(1);
                    }
                }
                monitor.subTask("Obtain new object node");
                int i = 0;
                while (i < 50) {
                    if (monitor.isCanceled()) break;
                    this.newNode = DBWorkbench.getPlatform().getNavigatorModel().findNode(this.newObject);
                    if (this.newNode != null) break;
                    RuntimeUtils.pause((int)100);
                    ++i;
                }
                monitor.worked(1);
                this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        UIUtils.syncExec(() -> this.openNewObject(newNode));
                    }
                });
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        private void openNewObject(@Nullable DBNDatabaseNode newChild) {
            block7: {
                IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                try {
                    if (newChild != null) {
                        DatabaseNavigatorView view = (DatabaseNavigatorView)UIUtils.findView((IWorkbenchWindow)workbenchWindow, DatabaseNavigatorView.class);
                        if (view != null) {
                            view.showNode((DBNNode)newChild);
                        }
                        boolean openEditor = this.parentObject instanceof DBSObject && (this.objectMaker.getMakerOptions(((DBSObject)this.parentObject).getDataSource()) & 4L) != 0L;
                        IDatabaseEditor editor = this.commandTarget.getEditor();
                        if (editor != null) {
                            workbenchWindow.getActivePage().activate((IWorkbenchPart)editor);
                        } else if (openEditor) {
                            DatabaseNodeEditorInput editorInput = new DatabaseNodeEditorInput(newChild, this.commandTarget.getContext());
                            editorInput.setDefaultPageId("default.object.editor");
                            workbenchWindow.getActivePage().openEditor((IEditorInput)editorInput, EntityEditor.class.getName());
                        }
                        break block7;
                    }
                    throw new DBException("Can't find node corresponding to new object");
                }
                catch (Throwable e) {
                    DBWorkbench.getPlatformUI().showError("Create object", null, e);
                }
            }
        }
    }

    private static class ObjectCreator<OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBPObject>
    implements DBRRunnableWithProgress {
        private final DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker;
        private final NavigatorHandlerObjectBase.CommandTarget commandTarget;
        private final CONTAINER_TYPE parentObject;
        private final DBSObject sourceObject;
        private OBJECT_TYPE newObject;
        private Map<String, Object> options;

        ObjectCreator(DBEObjectMaker<OBJECT_TYPE, CONTAINER_TYPE> objectMaker, NavigatorHandlerObjectBase.CommandTarget commandTarget, CONTAINER_TYPE parentObject, DBSObject sourceObject, Map<String, Object> options) {
            this.objectMaker = objectMaker;
            this.commandTarget = commandTarget;
            this.parentObject = parentObject;
            this.sourceObject = sourceObject;
            this.options = options;
        }

        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Create new database object", 1);
            try {
                try {
                    monitor.subTask("Create object instance");
                    this.newObject = this.objectMaker.createNewObject(monitor, this.commandTarget.getContext(), this.parentObject, (Object)this.sourceObject, this.options);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

