/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.plan;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanOperator;
import org.jkiss.dbeaver.model.DBPNamedValueObject;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;

public class DB2PlanOperatorPredicate
implements DBPNamedValueObject {
    private DB2PlanOperator db2Operator;
    private Integer predicateId;
    private String howApplied;
    private String whenEvaluated;
    private String predicateText;
    private String displayName;

    public DB2PlanOperatorPredicate(JDBCResultSet dbResult, DB2PlanOperator db2Operator) {
        this.db2Operator = db2Operator;
        this.predicateId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PREDICATE_ID");
        this.howApplied = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"HOW_APPLIED");
        this.whenEvaluated = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"WHEN_EVALUATED");
        this.predicateText = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PREDICATE_TEXT");
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.predicateId);
        if (this.whenEvaluated != null) {
            sb.append(" - ");
            sb.append(this.whenEvaluated);
        }
        sb.append(" ");
        sb.append(this.howApplied);
        this.displayName = sb.toString();
    }

    @NotNull
    public String getName() {
        return this.displayName;
    }

    @NotNull
    public Object getObjectValue() {
        return this.predicateText;
    }

    public String toString() {
        return this.predicateText;
    }

    public Integer getPredicateId() {
        return this.predicateId;
    }

    public String getHowApplied() {
        return this.howApplied;
    }

    public String getWhenEvaluated() {
        return this.whenEvaluated;
    }

    public String getPredicateText() {
        return this.predicateText;
    }

    public DB2PlanOperator getDb2Operator() {
        return this.db2Operator;
    }
}

