/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import org.eclipse.jface.action.IContributionManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.DateTimeInlineEditor;
import org.jkiss.dbeaver.ui.data.editors.DateTimeStandaloneEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;

public class DateTimeValueManager
extends BaseValueManager {
    protected static final Log log = Log.getLog(DateTimeValueManager.class);

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller, @Nullable IValueEditor activeEditor) throws DBCException {
        super.contributeActions(manager, controller, activeEditor);
    }

    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.INLINE, IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: 
            case PANEL: {
                return new DateTimeInlineEditor(controller);
            }
            case EDITOR: {
                return new DateTimeStandaloneEditor(controller);
            }
        }
        return null;
    }
}

