/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.select.SelectItem;

public class StructType
extends ASTNodeAccessImpl
implements Expression {
    private Dialect dialect = Dialect.BIG_QUERY;
    private String keyword;
    private List<Map.Entry<String, ColDataType>> parameters;
    private List<SelectItem<?>> arguments;

    public StructType(Dialect dialect, String keyword, List<Map.Entry<String, ColDataType>> parameters, List<SelectItem<?>> arguments) {
        this.dialect = dialect;
        this.keyword = keyword;
        this.parameters = parameters;
        this.arguments = arguments;
    }

    public StructType(Dialect dialect, List<Map.Entry<String, ColDataType>> parameters, List<SelectItem<?>> arguments) {
        this.dialect = dialect;
        this.parameters = parameters;
        this.arguments = arguments;
    }

    public StructType(Dialect dialect, List<SelectItem<?>> arguments) {
        this.dialect = dialect;
        this.arguments = arguments;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public StructType setDialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public StructType setKeyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public List<Map.Entry<String, ColDataType>> getParameters() {
        return this.parameters;
    }

    public StructType setParameters(List<Map.Entry<String, ColDataType>> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<SelectItem<?>> getArguments() {
        return this.arguments;
    }

    public StructType setArguments(List<SelectItem<?>> arguments) {
        this.arguments = arguments;
        return this;
    }

    public StructType add(Expression expression, String aliasName) {
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        this.arguments.add(new SelectItem<Expression>(expression, aliasName));
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (this.dialect != Dialect.DUCKDB && this.keyword != null) {
            builder.append(this.keyword);
        }
        if (this.dialect != Dialect.DUCKDB && this.parameters != null && !this.parameters.isEmpty()) {
            builder.append("<");
            i = 0;
            for (Map.Entry<String, ColDataType> entry : this.parameters) {
                if (0 < i++) {
                    builder.append(",");
                }
                if (entry.getKey() != null && !entry.getKey().isEmpty()) {
                    builder.append(entry.getKey()).append(" ");
                }
                builder.append(entry.getValue());
            }
            builder.append(">");
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            if (this.dialect == Dialect.DUCKDB) {
                builder.append("{ ");
                i = 0;
                for (SelectItem selectItem : this.arguments) {
                    if (0 < i++) {
                        builder.append(",");
                    }
                    builder.append(selectItem.getAlias().getName());
                    builder.append(":");
                    builder.append(selectItem.getExpression());
                }
                builder.append(" }");
            } else {
                builder.append("(");
                i = 0;
                for (SelectItem selectItem : this.arguments) {
                    if (0 < i++) {
                        builder.append(",");
                    }
                    selectItem.appendTo(builder);
                }
                builder.append(")");
            }
        }
        if (this.dialect == Dialect.DUCKDB && this.parameters != null && !this.parameters.isEmpty()) {
            builder.append("::STRUCT( ");
            i = 0;
            for (Map.Entry entry : this.parameters) {
                if (0 < i++) {
                    builder.append(",");
                }
                builder.append((String)entry.getKey()).append(" ");
                builder.append(entry.getValue());
            }
            builder.append(")");
        }
        return builder;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    public static enum Dialect {
        BIG_QUERY,
        DUCKDB;

    }
}

