/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class LambdaExpression
extends ASTNodeAccessImpl
implements Expression {
    private List<String> identifiers;
    private Expression expression;

    public LambdaExpression(String identifier, Expression expression) {
        this.identifiers = Collections.singletonList(identifier);
        this.expression = expression;
    }

    public LambdaExpression(List<String> identifiers, Expression expression) {
        this.identifiers = identifiers;
        this.expression = expression;
    }

    public static LambdaExpression from(ExpressionList<? extends Expression> expressionList, Expression expression) {
        ArrayList<String> identifiers = new ArrayList<String>(expressionList.size());
        for (Expression expression2 : expressionList) {
            identifiers.add(expression2.toString());
        }
        return new LambdaExpression(identifiers, expression);
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public LambdaExpression setIdentifiers(List<String> identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public LambdaExpression setExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        if (this.identifiers.size() == 1) {
            builder.append(this.identifiers.get(0));
        } else {
            int i = 0;
            builder.append("( ");
            for (String s : this.identifiers) {
                builder.append(i++ > 0 ? ", " : "").append(s);
            }
            builder.append(" )");
        }
        return builder.append(" -> ").append(this.expression);
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }
}

