/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.Buffer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPrivateKeySpec;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.NamedParameterSpec;
import java.util.Arrays;

abstract class SignatureEdDSA
implements com.jcraft.jsch.SignatureEdDSA {
    Signature signature;
    KeyFactory keyFactory;

    SignatureEdDSA() {
    }

    abstract String getName();

    abstract String getAlgo();

    abstract int getKeylen();

    @Override
    public void init() throws Exception {
        this.signature = Signature.getInstance("EdDSA");
        this.keyFactory = KeyFactory.getInstance("EdDSA");
    }

    @Override
    public void setPubKey(byte[] y_arr) throws Exception {
        boolean xOdd = ((y_arr = this.rotate(y_arr))[0] & 0x80) != 0;
        y_arr[0] = (byte)(y_arr[0] & 0x7F);
        BigInteger y = new BigInteger(y_arr);
        NamedParameterSpec paramSpec = new NamedParameterSpec(this.getAlgo());
        EdECPublicKeySpec pubSpec = new EdECPublicKeySpec(paramSpec, new EdECPoint(xOdd, y));
        PublicKey pubKey = this.keyFactory.generatePublic(pubSpec);
        this.signature.initVerify(pubKey);
    }

    @Override
    public void setPrvKey(byte[] bytes) throws Exception {
        NamedParameterSpec paramSpec = new NamedParameterSpec(this.getAlgo());
        EdECPrivateKeySpec privSpec = new EdECPrivateKeySpec(paramSpec, bytes);
        PrivateKey prvKey = this.keyFactory.generatePrivate(privSpec);
        this.signature.initSign(prvKey);
    }

    @Override
    public byte[] sign() throws Exception {
        byte[] sig = this.signature.sign();
        return sig;
    }

    @Override
    public void update(byte[] foo) throws Exception {
        this.signature.update(foo);
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        int i = 0;
        int j = 0;
        Buffer buf = new Buffer(sig);
        String foo = new String(buf.getString(), StandardCharsets.UTF_8);
        if (foo.equals(this.getName())) {
            j = buf.getInt();
            i = buf.getOffSet();
            byte[] tmp = new byte[j];
            System.arraycopy(sig, i, tmp, 0, j);
            sig = tmp;
        }
        return this.signature.verify(sig);
    }

    private byte[] rotate(byte[] in) {
        int len = in.length;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = in[len - i - 1];
        }
        return Arrays.copyOf(out, this.getKeylen());
    }
}

