/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformerExt;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.sql.SQLQuery;

public class QueryTransformerLimitCubrid
extends QueryTransformerLimit
implements DBCQueryTransformerExt {
    public QueryTransformerLimitCubrid() {
        super(true);
    }

    public boolean isApplicableTo(SQLQuery query) {
        Statement statement = query.getStatement();
        return statement != null && this.isLimitApplicable(statement);
    }

    public boolean isLimitApplicable(Statement statement) {
        if (statement instanceof PlainSelect) {
            PlainSelect select = (PlainSelect)statement;
            String where = String.valueOf(select.getWhere()).toUpperCase();
            if (where.contains("ROWNUM") || where.contains("INST_NUM")) {
                return false;
            }
            String having = String.valueOf(select.getHaving()).toUpperCase();
            if (having.contains("GROUPBY_NUM")) {
                return false;
            }
        }
        return true;
    }

    public String transformQueryString(SQLQuery query) throws DBCException {
        String sql = super.transformQueryString(query);
        CubridDataSource dataSource = (CubridDataSource)query.getDataSource();
        return dataSource.wrapShardQuery(sql);
    }
}

