/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsTableValueModel
extends SQLQueryRowsSourceModel {
    @NotNull
    private final List<List<SQLQueryValueExpression>> rows;
    private final boolean isIncomplete;

    public SQLQueryRowsTableValueModel(@NotNull STMTreeNode syntaxNode, @NotNull List<List<SQLQueryValueExpression>> rows, boolean isIncomplete) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.rows = rows;
        this.isIncomplete = isIncomplete;
    }

    @NotNull
    public List<SQLQueryValueExpression> getValues() {
        return this.rows.isEmpty() ? Collections.emptyList() : this.rows.getFirst();
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return this.isIncomplete ? context.resetAsUnresolved() : context.reset();
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        LinkedList<SQLQueryResultColumn> resultColumns = new LinkedList<SQLQueryResultColumn>();
        SQLQueryRowsDataContext emptyTuple = this.getRowsSources().makeEmptyTuple();
        int rowIndex = 0;
        for (List<SQLQueryValueExpression> row : this.rows) {
            for (SQLQueryValueExpression value : row) {
                value.resolveRowSources(this.getRowsSources(), statistics);
                value.resolveValueRelations(emptyTuple, statistics);
                if (rowIndex != 0) continue;
                resultColumns.addLast(new SQLQueryResultColumn(resultColumns.size(), new SQLQuerySymbol("?"), this, null, null, SQLQueryExprType.UNKNOWN));
            }
            ++rowIndex;
        }
        return this.getRowsSources().makeTuple(this, List.copyOf(resultColumns), Collections.emptyList());
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsTableValue(this, arg);
    }
}

