/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.verification;

import com.hierynomus.sshj.transport.verification.KnownHostMatchers;
import com.hierynomus.sshj.userauth.certificate.Certificate;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import net.schmizz.sshj.common.Base64Decoder;
import net.schmizz.sshj.common.Base64DecodingException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.slf4j.Logger;

public class OpenSSHKnownHosts
implements HostKeyVerifier {
    protected final Logger log;
    protected final File khFile;
    protected final List<KnownHostEntry> entries = new ArrayList<KnownHostEntry>();
    private static final String LS = System.getProperty("line.separator");

    public OpenSSHKnownHosts(Reader reader) throws IOException {
        this(reader, LoggerFactory.DEFAULT);
    }

    public OpenSSHKnownHosts(File khFile) throws IOException {
        this(khFile, LoggerFactory.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSSHKnownHosts(File khFile, LoggerFactory loggerFactory) throws IOException {
        this.khFile = khFile;
        this.log = loggerFactory.getLogger(this.getClass());
        if (khFile.exists()) {
            BufferedReader br = new BufferedReader(new FileReader(khFile));
            try {
                this.readEntries(br);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                throw throwable;
            }
            IOUtils.closeQuietly(br);
        }
    }

    public OpenSSHKnownHosts(Reader reader, LoggerFactory loggerFactory) throws IOException {
        this.khFile = null;
        this.log = loggerFactory.getLogger(this.getClass());
        BufferedReader br = new BufferedReader(reader);
        this.readEntries(br);
    }

    private void readEntries(BufferedReader br) throws IOException {
        String line;
        EntryFactory entryFactory = new EntryFactory();
        while ((line = br.readLine()) != null) {
            try {
                KnownHostEntry entry = entryFactory.parseEntry(line);
                if (entry == null) continue;
                this.entries.add(entry);
            }
            catch (SSHException ignore) {
                this.log.debug("Bad line ({}): {} ", (Object)ignore.toString(), (Object)line);
            }
            catch (SSHRuntimeException ignore) {
                this.log.debug("Failed to process line ({}): {} ", (Object)ignore.toString(), (Object)line);
            }
        }
    }

    private String adjustHostname(String hostname, int port) {
        String lowerHN = hostname.toLowerCase();
        return port != 22 ? "[" + lowerHN + "]:" + port : lowerHN;
    }

    public File getFile() {
        return this.khFile;
    }

    @Override
    public boolean verify(String hostname, int port, PublicKey key) {
        KeyType type = KeyType.fromKey(key);
        if (type == KeyType.UNKNOWN) {
            return false;
        }
        String adjustedHostname = this.adjustHostname(hostname, port);
        boolean foundApplicableHostEntry = false;
        for (KnownHostEntry e : this.entries) {
            try {
                if (!e.appliesTo(type, adjustedHostname)) continue;
                foundApplicableHostEntry = true;
                if (!e.verify(key)) continue;
                return true;
            }
            catch (IOException ioe) {
                this.log.error("Error with {}: {}", (Object)e, (Object)ioe);
                return false;
            }
        }
        if (foundApplicableHostEntry) {
            return this.hostKeyChangedAction(adjustedHostname, key);
        }
        return this.hostKeyUnverifiableAction(adjustedHostname, key);
    }

    @Override
    public List<String> findExistingAlgorithms(String hostname, int port) {
        String adjustedHostname = this.adjustHostname(hostname, port);
        ArrayList<String> knownHostAlgorithms = new ArrayList<String>();
        for (KnownHostEntry e : this.entries) {
            try {
                if (!e.appliesTo(adjustedHostname)) continue;
                KeyType type = e.getType();
                if (e instanceof HostEntry && ((HostEntry)e).marker == Marker.CA_CERT) {
                    for (KeyType candidate : KeyType.values()) {
                        if (candidate.getParent() == null) continue;
                        knownHostAlgorithms.add(candidate.toString());
                    }
                    continue;
                }
                knownHostAlgorithms.add(type.toString());
            }
            catch (IOException iOException) {}
        }
        return knownHostAlgorithms;
    }

    protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
        return false;
    }

    protected boolean hostKeyChangedAction(String hostname, PublicKey key) {
        this.log.warn("Host key for `{}` has changed!", (Object)hostname);
        return false;
    }

    public List<KnownHostEntry> entries() {
        return this.entries;
    }

    public void write() throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.khFile));){
            for (KnownHostEntry entry : this.entries) {
                bos.write((entry.getLine() + LS).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public void write(KnownHostEntry entry) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.khFile, true));
        try {
            writer.write(entry.getLine());
            writer.newLine();
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
    }

    public static File detectSSHDir() {
        File sshDir = new File(System.getProperty("user.home"), ".ssh");
        return sshDir.exists() ? sshDir : null;
    }

    public String toString() {
        return "OpenSSHKnownHosts{khFile='" + this.khFile + "'}";
    }

    public static enum Marker {
        CA_CERT("@cert-authority"),
        REVOKED("@revoked");

        private final String sMarker;

        private Marker(String sMarker) {
            this.sMarker = sMarker;
        }

        public String getMarkerString() {
            return this.sMarker;
        }

        public static Marker fromString(String str) {
            for (Marker m : Marker.values()) {
                if (!m.sMarker.equals(str)) continue;
                return m;
            }
            return null;
        }
    }

    public static class BadHostEntry
    implements KnownHostEntry {
        private final String line;

        public BadHostEntry(String line) {
            this.line = line;
        }

        @Override
        public KeyType getType() {
            return KeyType.UNKNOWN;
        }

        @Override
        public String getFingerprint() {
            return null;
        }

        @Override
        public boolean appliesTo(String host) throws IOException {
            return false;
        }

        @Override
        public boolean appliesTo(KeyType type, String host) throws IOException {
            return false;
        }

        @Override
        public boolean verify(PublicKey key) throws IOException {
            return false;
        }

        @Override
        public String getLine() {
            return this.line;
        }
    }

    public static class HostEntry
    implements KnownHostEntry {
        final Marker marker;
        private final String hostPart;
        protected final KeyType type;
        protected final PublicKey key;
        private final String comment;
        private final KnownHostMatchers.HostMatcher matcher;
        protected final Logger log;

        public HostEntry(Marker marker, String hostPart, KeyType type, PublicKey key) throws SSHException {
            this(marker, hostPart, type, key, "");
        }

        public HostEntry(Marker marker, String hostPart, KeyType type, PublicKey key, String comment) throws SSHException {
            this(marker, hostPart, type, key, comment, LoggerFactory.DEFAULT);
        }

        public HostEntry(Marker marker, String hostPart, KeyType type, PublicKey key, String comment, LoggerFactory loggerFactory) throws SSHException {
            this.marker = marker;
            this.hostPart = hostPart;
            this.type = type;
            this.key = key;
            this.comment = comment;
            this.matcher = KnownHostMatchers.createMatcher(hostPart);
            this.log = loggerFactory.getLogger(this.getClass());
        }

        @Override
        public KeyType getType() {
            return this.type;
        }

        @Override
        public String getFingerprint() {
            return SecurityUtils.getFingerprint(this.key);
        }

        @Override
        public boolean appliesTo(String host) throws IOException {
            return this.matcher.match(host);
        }

        @Override
        public boolean appliesTo(KeyType type, String host) throws IOException {
            return (this.type == type || this.marker == Marker.CA_CERT && type.getParent() != null) && this.matcher.match(host);
        }

        @Override
        public boolean verify(PublicKey key) throws IOException {
            if (this.marker == Marker.CA_CERT && key instanceof Certificate) {
                PublicKey caKey = new Buffer.PlainBuffer(((Certificate)key).getSignatureKey()).readPublicKey();
                return this.type == KeyType.fromKey(caKey) && this.getKeyString(caKey).equals(this.getKeyString(this.key));
            }
            return this.getKeyString(key).equals(this.getKeyString(this.key)) && this.marker != Marker.REVOKED;
        }

        @Override
        public String getLine() {
            StringBuilder line = new StringBuilder();
            if (this.marker != null) {
                line.append(this.marker.getMarkerString()).append(" ");
            }
            line.append(this.getHostPart());
            line.append(" ").append(this.type.toString());
            line.append(" ").append(this.getKeyString(this.key));
            if (this.comment != null && !this.comment.isEmpty()) {
                line.append(" ").append(this.comment);
            }
            return line.toString();
        }

        private String getKeyString(PublicKey pk) {
            Buffer.PlainBuffer buf = (Buffer.PlainBuffer)new Buffer.PlainBuffer().putPublicKey(pk);
            return Base64.getEncoder().encodeToString(Arrays.copyOfRange(buf.array(), buf.rpos(), buf.available()));
        }

        protected String getHostPart() {
            return this.hostPart;
        }

        public String getComment() {
            return this.comment;
        }
    }

    public static class CommentEntry
    implements KnownHostEntry {
        private final String comment;

        public CommentEntry(String comment) {
            this.comment = comment;
        }

        @Override
        public KeyType getType() {
            return KeyType.UNKNOWN;
        }

        @Override
        public String getFingerprint() {
            return null;
        }

        @Override
        public boolean appliesTo(String host) throws IOException {
            return false;
        }

        @Override
        public boolean appliesTo(KeyType type, String host) {
            return false;
        }

        @Override
        public boolean verify(PublicKey key) {
            return false;
        }

        @Override
        public String getLine() {
            return this.comment;
        }
    }

    public static interface KnownHostEntry {
        public KeyType getType();

        public String getFingerprint();

        public boolean appliesTo(String var1) throws IOException;

        public boolean appliesTo(KeyType var1, String var2) throws IOException;

        public boolean verify(PublicKey var1) throws IOException;

        public String getLine();
    }

    public class EntryFactory {
        public KnownHostEntry parseEntry(String line) throws IOException {
            PublicKey key;
            String[] split;
            if (this.isComment(line)) {
                return new CommentEntry(line);
            }
            String trimmed = line.trim();
            int minComponents = 3;
            if (trimmed.startsWith("@")) {
                minComponents = 4;
            }
            if ((split = trimmed.split("\\s+", minComponents + 1)).length < minComponents) {
                OpenSSHKnownHosts.this.log.error("Error reading entry `{}`", (Object)line);
                return new BadHostEntry(line);
            }
            int i = 0;
            Marker marker = Marker.fromString(split[i]);
            if (marker != null) {
                // empty if block
            }
            int n = ++i;
            String hostnames = split[n];
            int n2 = ++i;
            ++i;
            String sType = split[n2];
            KeyType type = KeyType.fromString(sType);
            if (type != KeyType.UNKNOWN) {
                String sKey = split[i++];
                try {
                    byte[] keyBytes = Base64Decoder.decode(sKey);
                    key = new Buffer.PlainBuffer(keyBytes).readPublicKey();
                }
                catch (IOException | Base64DecodingException exception) {
                    OpenSSHKnownHosts.this.log.warn("Error decoding Base64 key bytes", (Throwable)exception);
                    return new BadHostEntry(line);
                }
            } else if (this.isBits(sType)) {
                type = KeyType.RSA;
                split = trimmed.split("\\s+", ++minComponents + 1);
                BigInteger e = new BigInteger(split[i++]);
                BigInteger n3 = new BigInteger(split[i++]);
                try {
                    KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
                    key = keyFactory.generatePublic(new RSAPublicKeySpec(n3, e));
                }
                catch (Exception ex) {
                    OpenSSHKnownHosts.this.log.error("Error reading entry `{}`, could not create key", (Object)line, (Object)ex);
                    return new BadHostEntry(line);
                }
            } else {
                OpenSSHKnownHosts.this.log.error("Error reading entry `{}`, could not determine type", (Object)line);
                return new BadHostEntry(line);
            }
            String comment = i < split.length ? split[i++] : null;
            return new HostEntry(marker, hostnames, type, key, comment);
        }

        private boolean isBits(String type) {
            try {
                Integer.parseInt(type);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private boolean isComment(String line) {
            return line.isEmpty() || line.startsWith("#");
        }

        public boolean isHashed(String line) {
            return line.startsWith("|1|");
        }
    }
}

