/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import com.hierynomus.sshj.sftp.RemoteResourceFilterConverter;
import com.hierynomus.sshj.sftp.RemoteResourceSelector;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.RenameFlags;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;

public class StatefulSFTPClient
extends SFTPClient {
    private String cwd = this.getSFTPEngine().canonicalize(".");

    public StatefulSFTPClient(SFTPEngine engine) throws IOException {
        super(engine);
        this.log.debug("Start dir = {}", (Object)this.cwd);
    }

    public StatefulSFTPClient(SessionFactory sessionFactory) throws IOException {
        super(sessionFactory);
        this.log.debug("Start dir = {}", (Object)this.cwd);
    }

    private synchronized String cwdify(String path) {
        return this.engine.getPathHelper().adjustForParent(this.cwd, path);
    }

    public synchronized void cd(String dirname) throws IOException {
        String targetCwd = this.cwdify(dirname);
        if (this.statExistence(targetCwd) == null) {
            throw new SFTPException(targetCwd + ": does not exist");
        }
        this.cwd = targetCwd;
        this.log.debug("CWD = {}", (Object)this.cwd);
    }

    public synchronized List<RemoteResourceInfo> ls() throws IOException {
        return this.ls(this.cwd, RemoteResourceSelector.ALL);
    }

    public synchronized List<RemoteResourceInfo> ls(RemoteResourceFilter filter) throws IOException {
        return this.ls(this.cwd, filter);
    }

    public synchronized String pwd() throws IOException {
        return super.canonicalize(this.cwd);
    }

    @Override
    public List<RemoteResourceInfo> ls(String path) throws IOException {
        return this.ls(path, RemoteResourceSelector.ALL);
    }

    @Override
    public List<RemoteResourceInfo> ls(String path, RemoteResourceFilter filter) throws IOException {
        return this.ls(path, RemoteResourceFilterConverter.selectorFrom(filter));
    }

    @Override
    public List<RemoteResourceInfo> ls(String path, RemoteResourceSelector selector) throws IOException {
        try (RemoteDirectory dir = this.getSFTPEngine().openDir(this.cwdify(path));){
            List<RemoteResourceInfo> list = dir.scan(selector == null ? RemoteResourceSelector.ALL : selector);
            return list;
        }
    }

    @Override
    public RemoteFile open(String filename, Set<OpenMode> mode, FileAttributes attrs) throws IOException {
        return super.open(this.cwdify(filename), mode, attrs);
    }

    @Override
    public RemoteFile open(String filename, Set<OpenMode> mode) throws IOException {
        return super.open(this.cwdify(filename), mode);
    }

    @Override
    public RemoteFile open(String filename) throws IOException {
        return super.open(this.cwdify(filename));
    }

    @Override
    public void mkdir(String dirname) throws IOException {
        super.mkdir(this.cwdify(dirname));
    }

    @Override
    public void mkdirs(String path) throws IOException {
        super.mkdirs(this.cwdify(path));
    }

    @Override
    public FileAttributes statExistence(String path) throws IOException {
        return super.statExistence(this.cwdify(path));
    }

    @Override
    public void rename(String oldpath, String newpath, Set<RenameFlags> renameFlags) throws IOException {
        super.rename(this.cwdify(oldpath), this.cwdify(newpath), renameFlags);
    }

    @Override
    public void rm(String filename) throws IOException {
        super.rm(this.cwdify(filename));
    }

    @Override
    public void rmdir(String dirname) throws IOException {
        super.rmdir(this.cwdify(dirname));
    }

    @Override
    public void symlink(String linkpath, String targetpath) throws IOException {
        super.symlink(this.cwdify(linkpath), this.cwdify(targetpath));
    }

    @Override
    public void setattr(String path, FileAttributes attrs) throws IOException {
        super.setattr(this.cwdify(path), attrs);
    }

    @Override
    public String readlink(String path) throws IOException {
        return super.readlink(this.cwdify(path));
    }

    @Override
    public FileAttributes stat(String path) throws IOException {
        return super.stat(this.cwdify(path));
    }

    @Override
    public FileAttributes lstat(String path) throws IOException {
        return super.lstat(this.cwdify(path));
    }

    @Override
    public void truncate(String path, long size) throws IOException {
        super.truncate(this.cwdify(path), size);
    }

    @Override
    public String canonicalize(String path) throws IOException {
        return super.canonicalize(this.cwdify(path));
    }

    @Override
    public void get(String source, String dest) throws IOException {
        super.get(this.cwdify(source), dest);
    }

    @Override
    public void get(String source, LocalDestFile dest) throws IOException {
        super.get(this.cwdify(source), dest);
    }

    @Override
    public void put(String source, String dest) throws IOException {
        super.put(source, this.cwdify(dest));
    }

    @Override
    public void put(LocalSourceFile source, String dest) throws IOException {
        super.put(source, this.cwdify(dest));
    }
}

