/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.transformation;

import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.transformation.GeoTransformation;
import org.cts.op.transformation.ParamBasedTransformation;

public class SevenParameterTransformation
extends AbstractCoordinateOperation
implements GeoTransformation,
ParamBasedTransformation {
    public static final int POSITION_VECTOR = 0;
    public static final int COORDINATE_FRAME = 1;
    public static final boolean LINEARIZED = true;
    public static final boolean NOT_LINEARIZED = false;
    private static final Identifier idBW = new Identifier("EPSG", "1033", "Position vector 7-parameter transformation (linearized)", "Bursa-Wolf (lin.)");
    private static final Identifier idSinBW = new Identifier(SevenParameterTransformation.class, "Position vector 7-parameter transformation");
    private static final Identifier idCFR = new Identifier("EPSG", "1032", "Frame Rotation (lin.)", "Coordinate Frame rotation (linearized)");
    private static final Identifier idSinCFR = new Identifier(SevenParameterTransformation.class, "Coordinate Frame rotation");
    private static final Identifier idT = new Identifier("EPSG", "1031", "Geocentric translation", "Translation");
    private final double tx;
    private final double ty;
    private final double tz;
    private final double rx;
    private final double ry;
    private final double rz;
    private final double scale;
    private final int rotationConvention;
    private final boolean linearized;
    private SevenParameterTransformation inverse;

    private SevenParameterTransformation(double tx, double ty, double tz, double rx, double ry, double rz, double scale, int rotationConvention, boolean linearized, double precision) {
        super(idT);
        if (rx == 0.0 && ry == 0.0 && rz == 0.0 && scale == 1.0) {
            this.setIdentifier(idT);
        } else if (linearized) {
            if (rotationConvention == 0) {
                this.setIdentifier(idBW);
            } else if (rotationConvention == 1) {
                this.setIdentifier(idCFR);
            } else {
                this.setIdentifier(new Identifier(SevenParameterTransformation.class));
            }
        } else if (rotationConvention == 0) {
            this.setIdentifier(idSinBW);
        } else if (rotationConvention == 1) {
            this.setIdentifier(idSinCFR);
        } else {
            this.setIdentifier(new Identifier(SevenParameterTransformation.class));
        }
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.scale = scale;
        this.rotationConvention = rotationConvention;
        this.linearized = linearized;
        this.precision = precision;
    }

    public static SevenParameterTransformation createSevenParameterTransformation(double tx, double ty, double tz, double rx_sec, double ry_sec, double rz_sec, double ds_ppm, int rotationConvention, boolean linearized) {
        return new SevenParameterTransformation(tx, ty, tz, rx_sec * Math.PI / 180.0 / 3600.0, ry_sec * Math.PI / 180.0 / 3600.0, rz_sec * Math.PI / 180.0 / 3600.0, 1.0 + ds_ppm / 1000000.0, rotationConvention, linearized, 0.5);
    }

    public static SevenParameterTransformation createSevenParameterTransformation(double tx, double ty, double tz, double rx_sec, double ry_sec, double rz_sec, double ds_ppm, int rotationConvention, boolean linearized, double precision) {
        return new SevenParameterTransformation(tx, ty, tz, rx_sec * Math.PI / 180.0 / 3600.0, ry_sec * Math.PI / 180.0 / 3600.0, rz_sec * Math.PI / 180.0 / 3600.0, 1.0 + ds_ppm / 1000000.0, rotationConvention, linearized, precision);
    }

    public static SevenParameterTransformation createBursaWolfTransformation(double tx, double ty, double tz, double rx_sec, double ry_sec, double rz_sec, double ds_ppm) {
        return new SevenParameterTransformation(tx, ty, tz, rx_sec * Math.PI / 180.0 / 3600.0, ry_sec * Math.PI / 180.0 / 3600.0, rz_sec * Math.PI / 180.0 / 3600.0, 1.0 + ds_ppm / 1000000.0, 0, true, 0.5);
    }

    public static SevenParameterTransformation createBursaWolfTransformation(double tx, double ty, double tz, double rx_sec, double ry_sec, double rz_sec, double ds_ppm, final SevenParameterTransformation inverse) {
        return new SevenParameterTransformation(tx, ty, tz, rx_sec * Math.PI / 180.0 / 3600.0, ry_sec * Math.PI / 180.0 / 3600.0, rz_sec * Math.PI / 180.0 / 3600.0, 1.0 + ds_ppm / 1000000.0, 0, true, 0.5){

            @Override
            public SevenParameterTransformation inverse() {
                return inverse;
            }
        };
    }

    public static SevenParameterTransformation createBursaWolfTransformation(double tx, double ty, double tz, double rx_sec, double ry_sec, double rz_sec, double ds_ppm, double precision) {
        return new SevenParameterTransformation(tx, ty, tz, rx_sec * Math.PI / 180.0 / 3600.0, ry_sec * Math.PI / 180.0 / 3600.0, rz_sec * Math.PI / 180.0 / 3600.0, 1.0 + ds_ppm / 1000000.0, 0, true, precision);
    }

    public static SevenParameterTransformation createCoordinateFrameRotation(double tx, double ty, double tz, double rx_sec, double ry_sec, double rz_sec, double ds_ppm) {
        return new SevenParameterTransformation(tx, ty, tz, rx_sec * Math.PI / 180.0 / 3600.0, ry_sec * Math.PI / 180.0 / 3600.0, rz_sec * Math.PI / 180.0 / 3600.0, 1.0 + ds_ppm / 1000000.0, 1, true, 0.5);
    }

    public static SevenParameterTransformation createCoordinateFrameRotation(double tx, double ty, double tz, double rx_sec, double ry_sec, double rz_sec, double ds_ppm, double precision) {
        return new SevenParameterTransformation(tx, ty, tz, rx_sec * Math.PI / 180.0 / 3600.0, ry_sec * Math.PI / 180.0 / 3600.0, rz_sec * Math.PI / 180.0 / 3600.0, 1.0 + ds_ppm / 1000000.0, 1, true, precision);
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 3) {
            throw new CoordinateDimensionException(coord, 3);
        }
        double rotationSign = this.rotationConvention == 0 ? 1.0 : -1.0;
        double x = coord[0];
        double y = coord[1];
        double z = coord[2];
        double srx = this.rx * rotationSign;
        double sry = this.ry * rotationSign;
        double srz = this.rz * rotationSign;
        srx = this.linearized ? srx : Math.sin(srx);
        sry = this.linearized ? sry : Math.sin(sry);
        srz = this.linearized ? srz : Math.sin(srz);
        coord[0] = this.tx + this.scale * (x + z * sry - y * srz);
        coord[1] = this.ty + this.scale * (y + x * srz - z * srx);
        coord[2] = this.tz + this.scale * (z + y * srx - x * sry);
        return coord;
    }

    @Override
    public SevenParameterTransformation inverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        this.inverse = this.inverseStandard();
        return this.inverse;
    }

    public SevenParameterTransformation inverseStandard() {
        return new SevenParameterTransformation(this.tx, this.ty, this.tz, this.rx, this.ry, this.rz, this.scale, this.rotationConvention, this.linearized, this.precision){

            @Override
            public double[] transform(double[] coord) throws IllegalCoordinateException {
                if (coord.length < 3) {
                    throw new CoordinateDimensionException(coord, 3);
                }
                double rotationSign = SevenParameterTransformation.this.rotationConvention == 0 ? 1.0 : -1.0;
                double x = coord[0] - SevenParameterTransformation.this.tx;
                double y = coord[1] - SevenParameterTransformation.this.ty;
                double z = coord[2] - SevenParameterTransformation.this.tz;
                double srx = SevenParameterTransformation.this.rx * rotationSign;
                double sry = SevenParameterTransformation.this.ry * rotationSign;
                double srz = SevenParameterTransformation.this.rz * rotationSign;
                srx = SevenParameterTransformation.this.linearized ? -srx : -Math.sin(srx);
                sry = SevenParameterTransformation.this.linearized ? -sry : -Math.sin(sry);
                srz = SevenParameterTransformation.this.linearized ? -srz : -Math.sin(srz);
                coord[0] = 1.0 / SevenParameterTransformation.this.scale * (x * (1.0 + srx * srx) + z * (sry + srx * srz) - y * (srz - srx * sry)) / (1.0 + srx * srx + sry * sry + srz * srz);
                coord[1] = 1.0 / SevenParameterTransformation.this.scale * (y * (1.0 + sry * sry) + x * (srz + srx * sry) - z * (srx - sry * srz)) / (1.0 + srx * srx + sry * sry + srz * srz);
                coord[2] = 1.0 / SevenParameterTransformation.this.scale * (z * (1.0 + srz * srz) + y * (srx + sry * srz) - x * (sry - srx * srz)) / (1.0 + srx * srx + sry * sry + srz * srz);
                return coord;
            }

            @Override
            public SevenParameterTransformation inverse() {
                return SevenParameterTransformation.this;
            }

            @Override
            public double getPrecision() {
                if (!SevenParameterTransformation.this.linearized) {
                    return this.precision;
                }
                if (Math.abs(SevenParameterTransformation.this.rx) + Math.abs(SevenParameterTransformation.this.ry) + Math.abs(SevenParameterTransformation.this.rz) < 1.0E-4) {
                    return this.precision * 0.9;
                }
                if (Math.abs(SevenParameterTransformation.this.rx) + Math.abs(SevenParameterTransformation.this.ry) + Math.abs(SevenParameterTransformation.this.rz) < 0.001) {
                    return this.precision * 0.5;
                }
                return this.precision * 0.1;
            }
        };
    }

    public SevenParameterTransformation inverse0063() {
        return new SevenParameterTransformation(this.tx, this.ty, this.tz, this.rx, this.ry, this.rz, this.scale, this.rotationConvention, this.linearized, this.precision){

            @Override
            public double[] transform(double[] coord) throws IllegalCoordinateException {
                if (coord.length < 3) {
                    throw new CoordinateDimensionException(coord, 3);
                }
                double rotationSign = SevenParameterTransformation.this.rotationConvention == 0 ? 1.0 : -1.0;
                double x = coord[0] - SevenParameterTransformation.this.tx;
                double y = coord[1] - SevenParameterTransformation.this.ty;
                double z = coord[2] - SevenParameterTransformation.this.tz;
                double srx = SevenParameterTransformation.this.rx * rotationSign;
                double sry = SevenParameterTransformation.this.ry * rotationSign;
                double srz = SevenParameterTransformation.this.rz * rotationSign;
                srx = SevenParameterTransformation.this.linearized ? srx : Math.sin(srx);
                sry = SevenParameterTransformation.this.linearized ? sry : Math.sin(sry);
                srz = SevenParameterTransformation.this.linearized ? srz : Math.sin(srz);
                double e = SevenParameterTransformation.this.scale;
                double e2 = e * e;
                double det = e * (e2 + srx * srx + sry * sry + srz * srz);
                coord[0] = (x * (e2 + srx * srx) + z * (srx * srz - e * sry) + y * (e * srz + srx * sry)) / det;
                coord[1] = (y * (e2 + sry * sry) + x * (sry * srx - e * srz) + z * (e * srx + sry * srz)) / det;
                coord[2] = (z * (e2 + srz * srz) + y * (srz * sry - e * srx) + x * (e * sry + srz * srx)) / det;
                return coord;
            }

            @Override
            public SevenParameterTransformation inverse() {
                return SevenParameterTransformation.this;
            }

            @Override
            public double getPrecision() {
                if (!SevenParameterTransformation.this.linearized) {
                    return this.precision;
                }
                if (Math.abs(SevenParameterTransformation.this.rx) + Math.abs(SevenParameterTransformation.this.ry) + Math.abs(SevenParameterTransformation.this.rz) < 1.0E-4) {
                    return this.precision * 0.9;
                }
                if (Math.abs(SevenParameterTransformation.this.rx) + Math.abs(SevenParameterTransformation.this.ry) + Math.abs(SevenParameterTransformation.this.rz) < 0.001) {
                    return this.precision * 0.5;
                }
                return this.precision * 0.1;
            }
        };
    }

    @Override
    public String toString() {
        return this.getName() + " (dX=" + (this.tx < 0.0 ? "" : "+") + this.tx + "m, dY=" + (this.ty < 0.0 ? "" : "+") + this.ty + "m, dZ=" + (this.tz < 0.0 ? "" : "+") + this.tz + "m, rX=" + (this.rx < 0.0 ? "" : "+") + this.rx * 180.0 * 3600.0 / Math.PI + "\", rY=" + (this.ry < 0.0 ? "" : "+") + this.ry * 180.0 * 3600.0 / Math.PI + "\", rZ=" + (this.rz < 0.0 ? "" : "+") + this.rz * 180.0 * 3600.0 / Math.PI + "\", ds=" + (this.scale < 0.0 ? "" : "+") + (this.scale - 1.0) * 1000000.0 + "ppm) precision = " + this.precision;
    }

    @Override
    public String toWKT() {
        StringBuilder w = new StringBuilder();
        w.append(",TOWGS84[");
        if (Math.abs(this.tx - Math.rint(this.tx)) < 1.0E-9) {
            w.append((int)this.tx);
        } else {
            w.append(this.tx);
        }
        w.append(',');
        if (Math.abs(this.ty - Math.rint(this.ty)) < 1.0E-9) {
            w.append((int)this.ty);
        } else {
            w.append(this.ty);
        }
        w.append(',');
        if (Math.abs(this.tz - Math.rint(this.tz)) < 1.0E-9) {
            w.append((int)this.tz);
        } else {
            w.append(this.tz);
        }
        w.append(',');
        double rxn = this.rx * 3600.0 * 180.0 / Math.PI;
        if (Math.abs(rxn - Math.rint(rxn)) < 1.0E-9) {
            w.append((int)rxn);
        } else {
            w.append(rxn);
        }
        w.append(',');
        double ryn = this.ry * 3600.0 * 180.0 / Math.PI;
        if (Math.abs(ryn - Math.rint(ryn)) < 1.0E-9) {
            w.append((int)ryn);
        } else {
            w.append(ryn);
        }
        w.append(',');
        double rzn = this.rz * 3600.0 * 180.0 / Math.PI;
        if (Math.abs(rzn - Math.rint(rzn)) < 1.0E-9) {
            w.append((int)rzn);
        } else {
            w.append(rzn);
        }
        w.append(',');
        w.append(Math.rint((this.scale - 1.0) * 1.0E15) / 1.0E9);
        w.append("]");
        return w.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CoordinateOperation) {
            if (this.isIdentity() && ((CoordinateOperation)o).isIdentity()) {
                return true;
            }
            if (o instanceof SevenParameterTransformation) {
                SevenParameterTransformation transfo = (SevenParameterTransformation)o;
                return this.tx == transfo.tx && this.ty == transfo.ty && this.tz == transfo.tz && this.rx == transfo.rx && this.ry == transfo.ry && this.rz == transfo.rz && this.scale == transfo.scale && this.rotationConvention == transfo.rotationConvention && this.linearized == transfo.linearized;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isIdentity()) {
            return 0;
        }
        int hash = 5;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.tx) ^ Double.doubleToLongBits(this.tx) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.ty) ^ Double.doubleToLongBits(this.ty) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.tz) ^ Double.doubleToLongBits(this.tz) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.rx) ^ Double.doubleToLongBits(this.rx) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.ry) ^ Double.doubleToLongBits(this.ry) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.rz) ^ Double.doubleToLongBits(this.rz) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.scale) ^ Double.doubleToLongBits(this.scale) >>> 32);
        hash = 67 * hash + this.rotationConvention;
        hash = 67 * hash + (this.linearized ? 1 : 0);
        return hash;
    }

    @Override
    public boolean isIdentity() {
        return this.tx == 0.0 && this.ty == 0.0 && this.tz == 0.0 && this.rx == 0.0 && this.ry == 0.0 && this.rz == 0.0 && this.scale == 1.0;
    }
}

