from typing import overload
from typing_extensions import Self

class Angle:
    @overload
    def __init__(self, *, ra: bool = False) -> None: ...
    @overload
    def __init__(self, a: Angle, /, *, ra: bool = False) -> None: ...
    @overload
    def __init__(self, a: float, /, *, ra: bool = False, radians: bool = False) -> None: ...
    @overload
    def __init__(self, a: list[float] | tuple[float, ...], /, *, ra: bool = False, radians: bool = False) -> None: ...
    @overload
    def __init__(self, a1: float, a2: float, /, *, ra: bool = False) -> None: ...
    @overload
    def __init__(self, a1: float, a2: float, a3: float, /, *, ra: bool = False) -> None: ...
    @overload
    def __init__(self, a1: float, a2: float, a3: float, a4: float, /, *, ra: bool = False) -> None: ...
    @staticmethod
    def reduce_deg(deg: float | Angle) -> float: ...
    @staticmethod
    def reduce_dms(degrees: float, minutes: float, seconds: float = 0.0) -> tuple[int, int, float, float]: ...
    @staticmethod
    def deg2dms(deg: float | Angle) -> tuple[int, int, float, float]: ...
    @staticmethod
    def dms2deg(degrees: float, minutes: float, seconds: float = 0.0) -> float: ...
    def get_tolerance(self) -> float: ...
    def set_tolerance(self, tol: float) -> None: ...
    def __call__(self) -> float: ...
    @overload
    def set(self, *, ra: bool = False) -> None: ...
    @overload
    def set(self, a: Angle, /, *, ra: bool = False) -> None: ...
    @overload
    def set(self, a: float, /, *, ra: bool = False, radians: bool = False) -> None: ...
    @overload
    def set(self, a: list[float] | tuple[float, ...], /, *, ra: bool = False, radians: bool = False) -> None: ...
    @overload
    def set(self, a1: float, a2: float, /, *, ra: bool = False) -> None: ...
    @overload
    def set(self, a1: float, a2: float, a3: float, /, *, ra: bool = False) -> None: ...
    @overload
    def set(self, a1: float, a2: float, a3: float, a4: float, /, *, ra: bool = False) -> None: ...
    def set_radians(self, rads: float) -> None: ...
    @overload
    def set_ra(self) -> None: ...
    @overload
    def set_ra(self, a: float | Angle | list[float] | tuple[float, ...], /) -> None: ...
    @overload
    def set_ra(self, a1: float, a2: float, /) -> None: ...
    @overload
    def set_ra(self, a1: float, a2: float, a3: float, /) -> None: ...
    @overload
    def set_ra(self, a1: float, a2: float, a3: float, a4: float, /) -> None: ...
    def dms_str(self, fancy: bool | None = True, n_dec: int = -1) -> str: ...
    def get_ra(self) -> float: ...
    def ra_str(self, fancy: bool | None = True, n_dec: int = -1) -> str: ...
    def rad(self) -> float: ...
    def dms_tuple(self) -> tuple[int, int, float, float]: ...
    def ra_tuple(self) -> tuple[int, int, float, float]: ...
    def to_positive(self) -> Self: ...
    def __eq__(self, b: float | Angle) -> bool: ...  # type: ignore[override]
    def __ne__(self, b: float | Angle) -> bool: ...  # type: ignore[override]
    def __lt__(self, b: float | Angle) -> bool: ...
    def __ge__(self, b: float | Angle) -> bool: ...
    def __gt__(self, b: float | Angle) -> bool: ...
    def __le__(self, b: float | Angle) -> bool: ...
    def __neg__(self) -> Angle: ...
    def __abs__(self) -> Angle: ...
    def __mod__(self, b: float | Angle) -> Angle: ...
    def __add__(self, b: float | Angle) -> Angle: ...
    def __sub__(self, b: float | Angle) -> Angle: ...
    def __mul__(self, b: float | Angle) -> Angle: ...
    def __div__(self, b: float | Angle) -> Angle: ...
    def __truediv__(self, b: float | Angle) -> Angle: ...
    def __pow__(self, b: float | Angle) -> Angle: ...
    def __imod__(self, b: float | Angle) -> Self: ...
    def __iadd__(self, b: float | Angle) -> Self: ...
    def __isub__(self, b: float | Angle) -> Self: ...
    def __imul__(self, b: float | Angle) -> Self: ...
    def __idiv__(self, b: float | Angle) -> Angle: ...
    def __itruediv__(self, b: float | Angle) -> Self: ...
    def __ipow__(self, b: float | Angle) -> Self: ...
    def __rmod__(self, b: float | Angle) -> Angle: ...
    def __radd__(self, b: float | Angle) -> Angle: ...
    def __rsub__(self, b: float | Angle) -> Angle: ...
    def __rmul__(self, b: float | Angle) -> Angle: ...
    def __rdiv__(self, b: float | Angle) -> Angle: ...
    def __rtruediv__(self, b: float | Angle) -> Angle: ...
    def __rpow__(self, b: float | Angle) -> Angle: ...
    def __float__(self) -> float: ...
    def __int__(self) -> int: ...
    def __round__(self, n: float = 0) -> Angle: ...

def main() -> None: ...
