/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VolumeType {
    STANDARD("standard"),
    IO1("io1"),
    IO2("io2"),
    GP2("gp2"),
    SC1("sc1"),
    ST1("st1"),
    GP3("gp3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VolumeType> VALUE_MAP;
    private final String value;

    private VolumeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VolumeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VolumeType> knownValues() {
        EnumSet<VolumeType> knownValues = EnumSet.allOf(VolumeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VolumeType.class, VolumeType::toString);
    }
}

