/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.oid4vci;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.models.ProtocolMapperModel;

public class Oid4vcProtocolMapperModel
extends ProtocolMapperModel {
    public static final String PATH = "claim.name";
    public static final String MANDATORY = "vc.mandatory";
    public static final String DISPLAY = "vc.display";
    private final ProtocolMapperModel protocolMapper;

    public Oid4vcProtocolMapperModel(ProtocolMapperModel protocolMapper) {
        this.protocolMapper = protocolMapper;
    }

    public List<String> getPath() {
        return Optional.ofNullable((String)this.protocolMapper.getConfig().get(PATH)).map(s -> s.split("\\.")).map(Arrays::asList).orElse(Collections.emptyList());
    }

    public void setPath(List<String> path) {
        this.protocolMapper.getConfig().put(PATH, Optional.ofNullable(path).map(l -> String.join((CharSequence)".", l)).orElse(null));
    }

    public boolean isMandatory() {
        return Optional.ofNullable((String)this.protocolMapper.getConfig().get(MANDATORY)).map(Boolean::valueOf).orElse(false);
    }

    public void setMandatory(Boolean mandatory) {
        if (mandatory == null) {
            this.protocolMapper.getConfig().remove(MANDATORY);
        } else {
            this.protocolMapper.getConfig().put(MANDATORY, String.valueOf(mandatory));
        }
    }

    public String getDisplay() {
        return (String)this.protocolMapper.getConfig().get(DISPLAY);
    }

    public void setDisplay(String display) {
        this.protocolMapper.getConfig().put(DISPLAY, display);
    }

    public String getId() {
        return this.protocolMapper.getId();
    }

    public void setId(String id) {
        this.protocolMapper.setId(id);
    }

    public String getName() {
        return this.protocolMapper.getName();
    }

    public void setName(String name) {
        this.protocolMapper.setName(name);
    }

    public String getProtocol() {
        return this.protocolMapper.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.protocolMapper.setProtocol(protocol);
    }

    public String getProtocolMapper() {
        return this.protocolMapper.getProtocolMapper();
    }

    public void setProtocolMapper(String protocolMapper) {
        this.protocolMapper.setProtocolMapper(protocolMapper);
    }

    public Map<String, String> getConfig() {
        return this.protocolMapper.getConfig();
    }

    public void setConfig(Map<String, String> config) {
        this.protocolMapper.setConfig(config);
    }

    public boolean equals(Object obj) {
        return this.protocolMapper.equals(obj);
    }

    public int hashCode() {
        return this.protocolMapper.hashCode();
    }
}

