/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.archive;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.archive.CoffArchiveMemberHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SecondLinkerMember
implements StructConverter {
    private int numberOfMembers;
    private int[] offsets;
    private int numberOfSymbols;
    private short[] indices;
    private List<String> stringTable = new ArrayList<String>();
    private long _fileOffset;
    private List<Integer> _stringLengths = new ArrayList<Integer>();

    public SecondLinkerMember(BinaryReader reader, CoffArchiveMemberHeader header, boolean skip) throws IOException {
        this._fileOffset = reader.getPointerIndex();
        this.numberOfMembers = reader.peekNextInt();
        boolean isLittleEndian = reader.isLittleEndian();
        if ((this.numberOfMembers & 0xFF000000) != 0 && (this.numberOfMembers & 0xFF) != 0) {
            throw new IOException("Invalid COFF: unable to determine big-endian or little-endian; too many members detected.");
        }
        if ((this.numberOfMembers & 0xFF000000) != 0) {
            reader.setLittleEndian(!reader.isLittleEndian());
        }
        this.numberOfMembers = reader.readNextInt();
        if (skip) {
            reader.setPointerIndex(reader.getPointerIndex() + (long)(this.numberOfMembers * 4));
        } else {
            this.offsets = reader.readNextIntArray(this.numberOfMembers);
        }
        this.numberOfSymbols = reader.readNextInt();
        if (skip) {
            reader.setPointerIndex(reader.getPointerIndex() + (long)(this.numberOfSymbols * 2));
        } else {
            this.indices = reader.readNextShortArray(this.numberOfSymbols);
        }
        for (int i = 0; i < this.numberOfSymbols; ++i) {
            String string = reader.readNextAsciiString();
            if (!skip) {
                this.stringTable.add(string);
            }
            this._stringLengths.add(string.length() + 1);
        }
        reader.setPointerIndex(this._fileOffset + header.getSize());
        reader.setLittleEndian(isLittleEndian);
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public int getNumberOfMembers() {
        return this.numberOfMembers;
    }

    public int[] getOffsets() {
        if (this.offsets == null) {
            throw new RuntimeException("SecondLinkerMember::getOffsets() has been skipped.");
        }
        return this.offsets;
    }

    public int getNumberOfSymbols() {
        return this.numberOfSymbols;
    }

    public short[] getIndices() {
        if (this.indices == null) {
            throw new RuntimeException("SecondLinkerMember::getIndices() has been skipped.");
        }
        return this.indices;
    }

    public List<String> getStringTable() {
        if (this.stringTable.isEmpty()) {
            throw new RuntimeException("SecondLinkerMember::getStringTable() has been skipped.");
        }
        return new ArrayList<String>(this.stringTable);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = StructConverterUtil.parseName(SecondLinkerMember.class);
        String uniqueName = name + "_" + this.numberOfMembers + "_" + this.numberOfSymbols;
        StructureDataType struct = new StructureDataType(uniqueName, 0);
        struct.add(DWORD, "numberOfMembers", null);
        struct.add((DataType)new ArrayDataType(DWORD, this.numberOfMembers, DWORD.getLength()), "offsets", null);
        struct.add(DWORD, "numberOfSymbols", null);
        struct.add((DataType)new ArrayDataType(WORD, this.numberOfSymbols, WORD.getLength()), "indices", null);
        for (int i = 0; i < this._stringLengths.size(); ++i) {
            Integer length = this._stringLengths.get(i);
            struct.add(STRING, length.intValue(), "string[" + i + "]", null);
        }
        return struct;
    }
}

