/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class PairingIteratorMerger<T, L extends T, R extends T>
implements Iterator<Pair<L, R>>,
Comparator<T>,
BiPredicate<L, R> {
    private final Iterator<L> left;
    private final Iterator<R> right;
    private L nextL;
    private R nextR;

    public PairingIteratorMerger(Iterator<L> left, Iterator<R> right) {
        this.left = left;
        this.right = right;
        this.findNext();
    }

    protected void findNext() {
        while (true) {
            if (this.nextL == null) {
                if (!this.left.hasNext()) {
                    return;
                }
                this.nextL = this.left.next();
            }
            if (this.nextR == null) {
                if (!this.right.hasNext()) {
                    return;
                }
                this.nextR = this.right.next();
            }
            if (this.test(this.nextL, this.nextR)) {
                return;
            }
            int cmp = this.compare(this.nextL, this.nextR);
            if (cmp <= 0) {
                this.nextL = null;
            }
            if (cmp < 0) continue;
            this.nextR = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextL != null && this.nextR != null;
    }

    @Override
    public Pair<L, R> next() {
        ImmutablePair ret = new ImmutablePair(this.nextL, this.nextR);
        this.findNext();
        return ret;
    }
}

