/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.timer;

import ghidra.util.Msg;
import ghidra.util.timer.GTimer;
import ghidra.util.timer.GTimerMonitor;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;

public class Watchdog
implements Closeable {
    private long defaultWatchdogTimeoutMS;
    private AtomicLong watchdogExpiresAt = new AtomicLong();
    private Runnable timeoutMethod;
    private GTimerMonitor watchdogTimer;

    public Watchdog(long defaultTimeoutMS, Runnable timeoutMethod) {
        this.defaultWatchdogTimeoutMS = defaultTimeoutMS;
        this.timeoutMethod = timeoutMethod;
        this.watchdogTimer = GTimer.scheduleRepeatingRunnable(defaultTimeoutMS, defaultTimeoutMS, this::watchdogWorker);
    }

    public void finalize() {
        if (this.watchdogTimer != null) {
            this.close();
            Msg.warn((Object)this, (Object)"Unclosed Watchdog");
        }
    }

    @Override
    public void close() {
        if (this.watchdogTimer != null) {
            this.watchdogTimer.cancel();
        }
        this.watchdogTimer = null;
        this.timeoutMethod = null;
    }

    private void watchdogWorker() {
        long now;
        long expiresAt = this.watchdogExpiresAt.get();
        if (expiresAt > 0L && (now = System.currentTimeMillis()) > expiresAt) {
            this.setEnabled(false);
            this.timeoutMethod.run();
        }
    }

    private void setEnabled(boolean b) {
        this.watchdogExpiresAt.set(b ? System.currentTimeMillis() + this.defaultWatchdogTimeoutMS : -1L);
    }

    public boolean isEnabled() {
        return this.watchdogExpiresAt.get() > 0L;
    }

    public void arm() {
        this.setEnabled(true);
    }

    public void disarm() {
        this.setEnabled(false);
    }
}

