/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;

public class HighLocal
extends HighVariable {
    private Address pcaddr;
    private HighSymbol symbol;

    public HighLocal(HighFunction high) {
        super(high);
    }

    public HighLocal(DataType type, Varnode vn, Varnode[] inst, Address pc, HighSymbol sym) {
        super(sym.getName(), type, vn, inst, sym.getHighFunction());
        this.pcaddr = pc;
        this.symbol = sym;
    }

    @Override
    public HighSymbol getSymbol() {
        return this.symbol;
    }

    public Address getPCAddress() {
        return this.pcaddr;
    }

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int attribId;
        long symref = decoder.readUnsignedInteger(AttributeId.ATTRIB_SYMREF);
        this.offset = -1;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId != AttributeId.ATTRIB_OFFSET.id()) continue;
            this.offset = (int)decoder.readSignedInteger();
            break;
        }
        this.decodeInstances(decoder);
        this.symbol = this.function.getLocalSymbolMap().getSymbol(symref);
        if (this.symbol == null) {
            throw new DecoderException("HighLocal is missing symbol");
        }
        this.name = this.offset < 0 ? this.symbol.getName() : "UNNAMED";
        this.pcaddr = this.symbol.getPCAddress();
        this.symbol.setHighVariable(this);
    }
}

