/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.imageview;

import java.awt.geom.AffineTransform;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.jkiss.dbeaver.ui.controls.imageview.ImageViewUtil;

class ImageViewCanvas
extends Canvas {
    final float ZOOMIN_RATE = 1.1f;
    final float ZOOMOUT_RATE = 0.9f;
    private Image sourceImage;
    private ImageData imageData;
    private AffineTransform transform = new AffineTransform();
    private SWTException error;

    public ImageViewCanvas(Composite parent) {
        this(parent, 0);
    }

    public ImageViewCanvas(Composite parent, int style) {
        super(parent, style | 0x200 | 0x100);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ImageViewCanvas.this.syncScrollBars();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ImageViewCanvas.this.paint(event.gc);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageViewCanvas.this.sourceImage != null && !ImageViewCanvas.this.sourceImage.isDisposed()) {
                    ImageViewCanvas.this.sourceImage.dispose();
                }
            }
        });
        this.initScrollBars();
    }

    private void paint(GC gc) {
        Rectangle clientRect = this.getClientArea();
        if (this.sourceImage != null) {
            Rectangle imageRect = ImageViewUtil.inverseTransformRect(this.transform, clientRect);
            int gap = 2;
            imageRect.x -= gap;
            imageRect.y -= gap;
            imageRect.width += 2 * gap;
            imageRect.height += 2 * gap;
            Rectangle imageBound = this.sourceImage.getBounds();
            imageRect = imageRect.intersection(imageBound);
            Rectangle destRect = ImageViewUtil.transformRect(this.transform, imageRect);
            gc.setBackground(this.getParent().getBackground());
            gc.fillRectangle(clientRect);
            gc.drawImage(this.sourceImage, imageRect.x, imageRect.y, imageRect.width, imageRect.height, destRect.x, destRect.y, destRect.width, destRect.height);
        } else {
            gc.setClipping(clientRect);
            gc.fillRectangle(clientRect);
            this.initScrollBars();
        }
    }

    private void initScrollBars() {
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setEnabled(false);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageViewCanvas.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        ScrollBar vertical = this.getVerticalBar();
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageViewCanvas.this.scrollVertically((ScrollBar)event.widget);
            }
        });
    }

    private void scrollHorizontally(ScrollBar scrollBar) {
        if (this.sourceImage == null) {
            return;
        }
        AffineTransform af = this.transform;
        double tx = af.getTranslateX();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(select - tx, 0.0));
        this.transform = af;
        this.syncScrollBars();
    }

    private void scrollVertically(ScrollBar scrollBar) {
        if (this.sourceImage == null) {
            return;
        }
        AffineTransform af = this.transform;
        double ty = af.getTranslateY();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(0.0, select - ty));
        this.transform = af;
        this.syncScrollBars();
    }

    public Image getSourceImage() {
        return this.sourceImage;
    }

    public void syncScrollBars() {
        if (this.sourceImage == null) {
            this.redraw();
            return;
        }
        AffineTransform af = this.transform;
        double sx = af.getScaleX();
        double sy = af.getScaleY();
        double tx = af.getTranslateX();
        double ty = af.getTranslateY();
        if (tx > 0.0) {
            tx = 0.0;
        }
        if (ty > 0.0) {
            ty = 0.0;
        }
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setIncrement(this.getClientArea().width / 100);
        horizontal.setPageIncrement(this.getClientArea().width);
        Rectangle imageBound = this.sourceImage.getBounds();
        int cw = this.getClientArea().width;
        int ch = this.getClientArea().height;
        if ((double)imageBound.width * sx > (double)cw) {
            horizontal.setMaximum((int)((double)imageBound.width * sx));
            horizontal.setEnabled(true);
            if ((int)(-tx) > horizontal.getMaximum() - cw) {
                tx = -horizontal.getMaximum() + cw;
            }
        } else {
            horizontal.setEnabled(false);
            tx = ((double)cw - (double)imageBound.width * sx) / 2.0;
        }
        horizontal.setSelection((int)(-tx));
        horizontal.setThumb(this.getClientArea().width);
        ScrollBar vertical = this.getVerticalBar();
        vertical.setIncrement(this.getClientArea().height / 100);
        vertical.setPageIncrement(this.getClientArea().height);
        if ((double)imageBound.height * sy > (double)ch) {
            vertical.setMaximum((int)((double)imageBound.height * sy));
            vertical.setEnabled(true);
            if ((int)(-ty) > vertical.getMaximum() - ch) {
                ty = -vertical.getMaximum() + ch;
            }
        } else {
            vertical.setEnabled(false);
            ty = ((double)ch - (double)imageBound.height * sy) / 2.0;
        }
        vertical.setSelection((int)(-ty));
        vertical.setThumb(this.getClientArea().height);
        af = AffineTransform.getScaleInstance(sx, sy);
        af.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        this.transform = af;
        this.redraw();
    }

    public Image loadImage(InputStream inputStream) {
        if (this.sourceImage != null && !this.sourceImage.isDisposed()) {
            this.sourceImage.dispose();
            this.sourceImage = null;
            this.imageData = null;
        }
        this.error = null;
        if (inputStream != null) {
            try {
                this.imageData = new ImageData(inputStream);
                this.sourceImage = new Image((Device)this.getDisplay(), this.imageData);
            }
            catch (SWTException e) {
                this.error = e;
            }
        }
        this.showOriginal();
        return this.sourceImage;
    }

    public SWTException getError() {
        return this.error;
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void updateImage(ImageData data) {
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
        }
        if (data != null) {
            this.sourceImage = new Image((Device)this.getDisplay(), data);
        }
        this.syncScrollBars();
    }

    public void fitCanvas() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle imageBound = this.sourceImage.getBounds();
        Rectangle destRect = this.getClientArea();
        double sx = (double)destRect.width / (double)imageBound.width;
        double sy = (double)destRect.height / (double)imageBound.height;
        double s = Math.min(sx, sy);
        double dx = 0.5 * (double)destRect.width;
        double dy = 0.5 * (double)destRect.height;
        this.centerZoom(dx, dy, s, new AffineTransform());
    }

    public void showOriginal() {
        if (this.sourceImage != null) {
            this.transform = new AffineTransform();
        }
        this.syncScrollBars();
    }

    public void reset() {
        this.sourceImage = null;
        this.redraw();
    }

    public void centerZoom(double dx, double dy, double scale, AffineTransform af) {
        af.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        af.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        af.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
        this.transform = af;
        this.syncScrollBars();
    }

    public void zoomIn() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.centerZoom(dx, dy, 1.1f, this.transform);
    }

    public void zoomOut() {
        if (this.sourceImage == null) {
            return;
        }
        Rectangle rect = this.getClientArea();
        int w = rect.width;
        int h = rect.height;
        double dx = (double)w / 2.0;
        double dy = (double)h / 2.0;
        this.centerZoom(dx, dy, 0.9f, this.transform);
    }
}

