/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitution;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class DriverSubstitutionDescriptor
extends AbstractDescriptor
implements DBPDriverSubstitutionDescriptor {
    private final String id;
    private final String name;
    private final String providerId;
    private final String driverId;
    private final AbstractDescriptor.ObjectType type;
    private volatile DBPDriverSubstitution instance;

    public DriverSubstitutionDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
        this.providerId = config.getAttribute("provider");
        this.driverId = config.getAttribute("driver");
        this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getProviderId() {
        return this.providerId;
    }

    @NotNull
    public String getDriverId() {
        return this.driverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DBPDriverSubstitution getInstance() {
        if (this.instance == null) {
            DriverSubstitutionDescriptor driverSubstitutionDescriptor = this;
            synchronized (driverSubstitutionDescriptor) {
                if (this.instance == null) {
                    try {
                        this.instance = (DBPDriverSubstitution)this.type.createInstance(DBPDriverSubstitution.class);
                    }
                    catch (Throwable ex) {
                        throw new IllegalStateException("Unable to initialize driver substitution " + this.type.getImplName() + "'", ex);
                    }
                }
            }
        }
        return this.instance;
    }
}

