/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.aggregator.AggregatorInstance;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.search.expression.BaseCriteria;
import net.sf.ehcache.search.expression.Criteria;
import net.sf.ehcache.search.impl.AggregateOnlyResult;
import net.sf.ehcache.search.impl.BaseResult;
import net.sf.ehcache.search.impl.GroupedResultImpl;
import net.sf.ehcache.search.impl.OrderComparator;
import net.sf.ehcache.search.impl.ResultImpl;
import net.sf.ehcache.search.impl.ResultsImpl;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.store.FrontEndCacheTier;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.NotifyingMemoryStore;
import net.sf.ehcache.store.NullStore;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.transaction.SoftLockID;

public class MemoryOnlyStore
extends FrontEndCacheTier<NullStore, MemoryStore> {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    protected MemoryOnlyStore(CacheConfiguration cacheConfiguration, MemoryStore authority, SearchManager searchManager) {
        super(NullStore.create(), authority, cacheConfiguration.getCopyStrategy(), searchManager, cacheConfiguration.isCopyOnWrite(), cacheConfiguration.isCopyOnRead());
    }

    public static Store create(Ehcache cache, Pool onHeapPool) {
        NotifyingMemoryStore memoryStore = NotifyingMemoryStore.create(cache, onHeapPool);
        BruteForceSearchManager searchManager = new BruteForceSearchManager();
        MemoryOnlyStore memoryOnlyStore = new MemoryOnlyStore(cache.getCacheConfiguration(), memoryStore, searchManager);
        searchManager.setMemoryStore(memoryOnlyStore);
        return memoryOnlyStore;
    }

    Collection<Element> elementSet() {
        return ((MemoryStore)this.authority).elementSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        Lock lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            Element element = this.copyElementForReadIfNeeded(((MemoryStore)this.authority).get(key));
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getQuiet(Object key) {
        if (key == null) {
            return null;
        }
        Lock lock = this.getLockFor(key).readLock();
        lock.lock();
        try {
            Element element = this.copyElementForReadIfNeeded(((MemoryStore)this.authority).getQuiet(key));
            return element;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        ((MemoryStore)this.authority).setInMemoryEvictionPolicy(policy);
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return ((MemoryStore)this.authority).getInMemoryEvictionPolicy();
    }

    @Override
    public Object getMBean() {
        return null;
    }

    protected static class BruteForceSearchManager
    implements SearchManager {
        private volatile MemoryOnlyStore memoryStore;

        public void setMemoryStore(MemoryOnlyStore memoryStore) {
            this.memoryStore = memoryStore;
        }

        @Override
        public void put(String cacheName, int segmentId, String uniqueKey, byte[] serializedKey, Element element, Map<String, AttributeExtractor> extractors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Results executeQuery(String cacheName, StoreQuery query, Map<String, AttributeExtractor> extractors) {
            Criteria c = query.getCriteria();
            List aggregators = query.getAggregatorInstances();
            Set<Attribute<?>> groupByAttributes = query.groupByAttributes();
            boolean isGroupBy = !groupByAttributes.isEmpty();
            boolean includeResults = query.requestsKeys() || query.requestsValues() || !query.requestedAttributes().isEmpty() || isGroupBy;
            boolean hasOrder = !query.getOrdering().isEmpty();
            HashMap<HashSet<Object>, BaseResult> groupByResults = new HashMap<HashSet<Object>, BaseResult>();
            HashMap groupByAggregators = new HashMap();
            int maxResults = query.maxResults();
            LinkedList<Element> matches = new LinkedList<Element>();
            for (Element element : this.memoryStore.elementSet()) {
                if ((element = this.memoryStore.copyElementForReadIfNeeded(element)).getObjectValue() instanceof SoftLockID || !c.execute(element, extractors)) continue;
                if (!isGroupBy && !hasOrder && query.maxResults() >= 0 && matches.size() == query.maxResults()) break;
                matches.add(element);
            }
            List<BaseResult> results = isGroupBy ? groupByResults.values() : new ArrayList();
            boolean anyMatches = !matches.isEmpty();
            for (Element element : matches) {
                if (includeResults) {
                    Map<String, Object> attributes = this.getAttributeValues(query.requestedAttributes(), extractors, element);
                    Object[] sortAttributes = this.getSortAttributes(query, extractors, element);
                    if (!isGroupBy) {
                        results.add(new ResultImpl(element.getObjectKey(), element.getObjectValue(), query, attributes, sortAttributes));
                    } else {
                        ArrayList groupAggrs;
                        Map<String, Object> groupByValues = this.getAttributeValues(groupByAttributes, extractors, element);
                        HashSet<Object> groupId = new HashSet<Object>(groupByValues.values());
                        BaseResult group = (BaseResult)groupByResults.get(groupId);
                        if (group == null) {
                            group = new GroupedResultImpl(query, attributes, sortAttributes, Collections.EMPTY_LIST, groupByValues);
                            groupByResults.put(groupId, group);
                        }
                        if ((groupAggrs = (ArrayList)groupByAggregators.get(groupId)) == null) {
                            groupAggrs = new ArrayList(aggregators.size());
                            for (AggregatorInstance aggr : aggregators) {
                                groupAggrs.add(aggr.createClone());
                            }
                            groupByAggregators.put(groupId, groupAggrs);
                        }
                        aggregators = groupAggrs;
                    }
                }
                this.aggregate(aggregators, extractors, element);
            }
            if (hasOrder || isGroupBy) {
                int max;
                if (isGroupBy) {
                    results = new ArrayList(results);
                }
                if (hasOrder) {
                    Collections.sort((List)results, new OrderComparator(query.getOrdering()));
                }
                if ((max = query.maxResults()) >= 0 && results.size() > max) {
                    results = ((List)results).subList(0, max);
                }
            }
            if (!aggregators.isEmpty()) {
                for (BaseResult result : results) {
                    if (isGroupBy) {
                        GroupedResultImpl group = (GroupedResultImpl)result;
                        HashSet<Object> groupId = new HashSet<Object>(group.getGroupByValues().values());
                        aggregators = (List)groupByAggregators.get(groupId);
                    }
                    this.setResultAggregators(aggregators, result);
                }
            }
            if (!isGroupBy && anyMatches && !includeResults && !aggregators.isEmpty()) {
                AggregateOnlyResult aggOnly = new AggregateOnlyResult(query);
                this.setResultAggregators(aggregators, aggOnly);
                results.add(aggOnly);
            }
            return new ResultsImpl((List<Result>)results, query.requestsKeys(), query.requestsValues(), !query.requestedAttributes().isEmpty(), anyMatches && !aggregators.isEmpty());
        }

        private void setResultAggregators(List<AggregatorInstance<?>> aggregators, BaseResult result) {
            ArrayList<Object> aggregateResults = new ArrayList<Object>();
            for (AggregatorInstance<?> aggregator : aggregators) {
                aggregateResults.add(aggregator.aggregateResult());
            }
            if (!aggregateResults.isEmpty()) {
                result.setAggregateResults(aggregateResults);
            }
        }

        private Map<String, Object> getAttributeValues(Set<Attribute<?>> attributes, Map<String, AttributeExtractor> extractors, Element element) {
            Map<String, Object> values;
            if (attributes.isEmpty()) {
                values = Collections.emptyMap();
            } else {
                values = new HashMap();
                for (Attribute<?> attribute : attributes) {
                    String name = attribute.getAttributeName();
                    values.put(name, BaseCriteria.getExtractor(name, extractors).attributeFor(element, name));
                }
            }
            return values;
        }

        private void aggregate(List<AggregatorInstance<?>> aggregators, Map<String, AttributeExtractor> extractors, Element element) {
            for (AggregatorInstance<?> aggregator : aggregators) {
                Attribute<?> attribute = aggregator.getAttribute();
                if (attribute == null) {
                    aggregator.accept(null);
                    continue;
                }
                Object val = BaseCriteria.getExtractor(attribute.getAttributeName(), extractors).attributeFor(element, attribute.getAttributeName());
                aggregator.accept(val);
            }
        }

        private Object[] getSortAttributes(StoreQuery query, Map<String, AttributeExtractor> extractors, Element element) {
            Object[] sortAttributes;
            List<StoreQuery.Ordering> orderings = query.getOrdering();
            if (orderings.isEmpty()) {
                sortAttributes = EMPTY_OBJECT_ARRAY;
            } else {
                sortAttributes = new Object[orderings.size()];
                for (int i = 0; i < sortAttributes.length; ++i) {
                    String name = orderings.get(i).getAttribute().getAttributeName();
                    sortAttributes[i] = BaseCriteria.getExtractor(name, extractors).attributeFor(element, name);
                }
            }
            return sortAttributes;
        }

        @Override
        public void remove(String cacheName, String uniqueKey, int segmentId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear(String cacheName, int segmentId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void move(String cacheName, int segmentId, String existingKey, String newKey) {
            throw new UnsupportedOperationException();
        }
    }
}

