/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.apache.solr.client.api.model.CollectionStatusResponse;

@Path(value="/collections/{collectionName}")
public interface CollectionStatusApi {
    @GET
    @Operation(summary="Fetches metadata about the specified collection", tags={"collections"})
    public CollectionStatusResponse getCollectionStatus(@Parameter(description="The name of the collection return metadata for", required=true) @PathParam(value="collectionName") String var1, @Parameter(description="Boolean flag to include metadata (e.g. index an data directories, IndexWriter configuration, etc.) about each shard leader's core") @QueryParam(value="coreInfo") Boolean var2, @Parameter(description="Boolean flag to include metadata and statistics about the segments used by each shard leader.  Implicitly set to true by 'fieldInfo' and 'sizeInfo'") @QueryParam(value="segments") Boolean var3, @Parameter(description="Boolean flag to include statistics about the indexed fields present on each shard leader. Implicitly sets the 'segments' flag to 'true'") @QueryParam(value="fieldInfo") Boolean var4, @Parameter(description="Boolean flag to include simple estimates of the disk size taken up by each field (e.g. \"id\", \"_version_\") and by each index data structure (e.g. 'storedFields', 'docValues_numeric').") @QueryParam(value="rawSize") Boolean var5, @Parameter(description="Boolean flag to include more involved estimates of the disk size taken up by index data structures, on a per-field basis (e.g. how much data does the \"id\" field contribute to 'storedField' index files).  More detail than 'rawSize', less detail than 'rawSizeDetails'.") @QueryParam(value="rawSizeSummary") Boolean var6, @Parameter(description="Boolean flag to include detailed statistics about the disk size taken up by various fields and data structures.  More detail than 'rawSize' and 'rawSizeSummary'.") @QueryParam(value="rawSizeDetails") Boolean var7, @Parameter(description="Percentage (between 0 and 100) of data to read when estimating index size and statistics.  Defaults to 5.0 (i.e. 5%).") @QueryParam(value="rawSizeSamplingPercent") Float var8, @Parameter(description="Boolean flag to include information about the largest index files for each Lucene segment.. Implicitly sets the 'segment' flag to 'true'") @QueryParam(value="sizeInfo") Boolean var9) throws Exception;
}

