/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.mapping.ComparisonFunction;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValue;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

public class EqualFunction {
    public static final String name = "equal";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 2) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The equal function requires 2 paramaters, " + params.length + " found.");
        }
        AnalyticsValueStream paramA = params[0];
        AnalyticsValueStream paramB = params[1];
        if (paramA instanceof BooleanValueStream && paramB instanceof BooleanValueStream) {
            if (paramA instanceof BooleanValue) {
                if (paramB instanceof BooleanValue) {
                    return new BooleanValueEqualFunction((BooleanValue)paramA, (BooleanValue)paramB);
                }
                return new BooleanStreamEqualFunction((BooleanValue)paramA, (BooleanValueStream)paramB);
            }
            if (paramB instanceof BooleanValue) {
                return new BooleanStreamEqualFunction((BooleanValue)paramB, (BooleanValueStream)paramA);
            }
        } else {
            if (paramA instanceof DoubleValueStream && paramB instanceof DoubleValueStream) {
                return ComparisonFunction.createComparisonFunction(name, val -> val == 0, params);
            }
            if (paramA instanceof AnalyticsValue) {
                if (paramB instanceof AnalyticsValue) {
                    return new ValueEqualFunction((AnalyticsValue)paramA, (AnalyticsValue)paramB);
                }
                return new StreamEqualFunction((AnalyticsValue)paramA, paramB);
            }
            if (paramB instanceof AnalyticsValue) {
                return new StreamEqualFunction((AnalyticsValue)paramB, paramA);
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The equal function requires that at least 1 parameter be single-valued.");
    };

    static class StreamEqualFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final AnalyticsValue baseExpr;
        private final AnalyticsValueStream compExpr;
        public static final String name = "equal";
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StreamEqualFunction(AnalyticsValue baseExpr, AnalyticsValueStream compExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.funcStr = AnalyticsValueStream.createExpressionString("equal", baseExpr, compExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            Object baseValue = this.baseExpr.getObject();
            if (this.baseExpr.exists()) {
                this.compExpr.streamObjects(compValue -> cons.accept(baseValue.equals(compValue)));
            }
        }

        @Override
        public String getName() {
            return "equal";
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class ValueEqualFunction
    extends BooleanValue.AbstractBooleanValue {
        private final AnalyticsValue exprA;
        private final AnalyticsValue exprB;
        public static final String name = "equal";
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public ValueEqualFunction(AnalyticsValue exprA, AnalyticsValue exprB) {
            this.exprA = exprA;
            this.exprB = exprB;
            this.funcStr = AnalyticsValueStream.createExpressionString("equal", exprA, exprB);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, exprA, exprB);
        }

        @Override
        public boolean getBoolean() {
            Object valueA = this.exprA.getObject();
            Object valueB = this.exprB.getObject();
            this.exists = this.exprA.exists() && this.exprB.exists();
            return this.exists ? valueA.equals(valueB) : false;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "equal";
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanStreamEqualFunction
    extends BooleanValueStream.AbstractBooleanValueStream {
        private final BooleanValue baseExpr;
        private final BooleanValueStream compExpr;
        public static final String name = "equal";
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public BooleanStreamEqualFunction(BooleanValue baseExpr, BooleanValueStream compExpr) throws SolrException {
            this.baseExpr = baseExpr;
            this.compExpr = compExpr;
            this.funcStr = AnalyticsValueStream.createExpressionString("equal", baseExpr, compExpr);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
        }

        @Override
        public void streamBooleans(BooleanConsumer cons) {
            boolean baseValue = this.baseExpr.getBoolean();
            if (this.baseExpr.exists()) {
                this.compExpr.streamBooleans(compValue -> cons.accept(baseValue == compValue));
            }
        }

        @Override
        public String getName() {
            return "equal";
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class BooleanValueEqualFunction
    extends BooleanValue.AbstractBooleanValue {
        private final BooleanValue exprA;
        private final BooleanValue exprB;
        public static final String name = "equal";
        private final String funcStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public BooleanValueEqualFunction(BooleanValue exprA, BooleanValue exprB) {
            this.exprA = exprA;
            this.exprB = exprB;
            this.funcStr = AnalyticsValueStream.createExpressionString("equal", exprA, exprB);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, exprA, exprB);
        }

        @Override
        public boolean getBoolean() {
            boolean valueA = this.exprA.getBoolean();
            boolean valueB = this.exprB.getBoolean();
            boolean bl = this.exists = this.exprA.exists() && this.exprB.exists();
            return this.exists ? valueA == valueB : false;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "equal";
        }

        @Override
        public String getExpressionStr() {
            return this.funcStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

