/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.results;

import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestResult;

public class TestListenerAdapter
implements TestListenerInternal {
    private final TestListener testListener;
    private final TestOutputListener testOutputListener;

    public TestListenerAdapter(TestListener testListener, TestOutputListener testOutputListener) {
        this.testListener = testListener;
        this.testOutputListener = testOutputListener;
    }

    @Override
    public void started(TestDescriptorInternal test, TestStartEvent startEvent) {
        if (test.isComposite()) {
            this.testListener.beforeSuite((TestDescriptor)test);
        } else {
            this.testListener.beforeTest((TestDescriptor)test);
        }
    }

    @Override
    public void completed(TestDescriptorInternal test, TestResult result, TestCompleteEvent completeEvent) {
        if (test.isComposite()) {
            this.testListener.afterSuite((TestDescriptor)test, result);
        } else {
            this.testListener.afterTest((TestDescriptor)test, result);
        }
    }

    @Override
    public void output(TestDescriptorInternal test, TestOutputEvent event) {
        this.testOutputListener.onOutput((TestDescriptor)test, event);
    }

    @Override
    public void metadata(TestDescriptorInternal testDescriptor, TestMetadataEvent event) {
    }
}

