/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.pickle;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.pickle.PUnpickler;
import com.oracle.graal.python.builtins.modules.pickle.PUnpicklerMemoProxy;
import com.oracle.graal.python.builtins.modules.pickle.UnpicklerMemoProxyBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.pickle.UnpicklerMemoProxyBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.UnpicklerMemoProxy})
public class UnpicklerMemoProxyBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = UnpicklerMemoProxyBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return UnpicklerMemoProxyBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class UnpicklerMemoProxyReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reduce(PUnpicklerMemoProxy self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Bind PythonLanguage language) {
            PDict dictMemoCopy = PFactory.createDict(language, self.getUnpickler().copyMemoToHashingStorage(inliningTarget, setItem));
            PTuple constructorArgs = PFactory.createTuple(language, new Object[]{dictMemoCopy});
            return PFactory.createTuple(language, new Object[]{PythonBuiltinClassType.PDict, constructorArgs});
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class UnpicklerMemoProxyCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object copy(PUnpicklerMemoProxy self, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Bind PythonLanguage language) {
            return PFactory.createDict(language, self.getUnpickler().copyMemoToHashingStorage(inliningTarget, setItem));
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class UnpicklerMemoProxyClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object clear(PUnpicklerMemoProxy self) {
            self.getUnpickler().clearMemo();
            return PNone.NONE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="UnpicklerMemoProxy", minNumOfPositionalArgs=2, parameterNames={"$cls", "unpickler"})
    @GenerateNodeFactory
    static abstract class ConstructUnpicklerMemoProxyNode
    extends PythonBinaryBuiltinNode {
        ConstructUnpicklerMemoProxyNode() {
        }

        @Specialization
        PUnpicklerMemoProxy construct(Object cls, PUnpickler unpickler, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createUnpicklerMemoProxy(language, unpickler, cls, getInstanceShape.execute(cls));
        }
    }
}

