/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.PromiseFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateDataPropertyNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseAllNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseAllSettledNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseAnyNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseCombinatorNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseRaceNode;
import com.oracle.truffle.js.nodes.promise.PromiseResolveNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class PromiseFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<PromiseFunction> {
    public static final JSBuiltinsContainer BUILTINS = new PromiseFunctionBuiltins();

    protected PromiseFunctionBuiltins() {
        super(JSPromise.CLASS_NAME, PromiseFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, PromiseFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return PromiseFunctionBuiltinsFactory.PromiseCombinatorNodeGen.create(context, builtin, PerformPromiseAllNode.create(context), PromiseFunctionBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return PromiseFunctionBuiltinsFactory.PromiseCombinatorNodeGen.create(context, builtin, PerformPromiseAllSettledNode.create(context), PromiseFunctionBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 5: {
                return PromiseFunctionBuiltinsFactory.PromiseCombinatorNodeGen.create(context, builtin, PerformPromiseAnyNode.create(context), PromiseFunctionBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return PromiseFunctionBuiltinsFactory.PromiseCombinatorNodeGen.create(context, builtin, PerformPromiseRaceNode.create(context), PromiseFunctionBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return PromiseFunctionBuiltinsFactory.RejectNodeGen.create(context, builtin, PromiseFunctionBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return PromiseFunctionBuiltinsFactory.ResolveNodeGen.create(context, builtin, PromiseFunctionBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 6: {
                return PromiseFunctionBuiltinsFactory.WithResolversNodeGen.create(context, builtin, PromiseFunctionBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 7: {
                return PromiseFunctionBuiltinsFactory.PromiseTryNodeGen.create(context, builtin, PromiseFunctionBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum PromiseFunction implements BuiltinEnum<PromiseFunction>
    {
        all(1),
        race(1),
        reject(1),
        resolve(1),
        allSettled(1),
        any(1),
        withResolvers(0),
        try_(1);

        private final int length;

        private PromiseFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 5 -> 12;
                case 4 -> 11;
                case 6 -> 15;
                case 7 -> 16;
                default -> 6;
            };
        }
    }

    public static abstract class PromiseCombinatorNode
    extends JSBuiltinNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        private PropertyGetNode getResolve;
        @Node.Child
        private IsCallableNode isCallable;
        @Node.Child
        private PerformPromiseCombinatorNode performPromiseOpNode;
        @Node.Child
        private JSFunctionCallNode callRejectNode;
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        protected PromiseCombinatorNode(JSContext context, JSBuiltin builtin, PerformPromiseCombinatorNode performPromiseOp) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.getResolve = PropertyGetNode.create(JSPromise.RESOLVE, context);
            this.isCallable = IsCallableNode.create();
            this.performPromiseOpNode = performPromiseOp;
        }

        @Specialization
        protected Object doObject(JSObject constructor, Object iterable, @Cached(inline=true) GetIteratorNode getIteratorNode) {
            IteratorRecord iteratorRecord;
            Object promiseResolve;
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.execute((Object)constructor);
            try {
                promiseResolve = this.getPromiseResolve(constructor);
                iteratorRecord = getIteratorNode.execute(this, iterable);
            }
            catch (AbstractTruffleException ex) {
                return this.rejectPromise(ex, promiseCapability);
            }
            try {
                return this.performPromiseOpNode.execute(iteratorRecord, constructor, promiseCapability, promiseResolve);
            }
            catch (AbstractTruffleException ex) {
                if (!iteratorRecord.isDone()) {
                    this.iteratorClose(iteratorRecord);
                }
                return this.rejectPromise(ex, promiseCapability);
            }
        }

        private Object getPromiseResolve(JSDynamicObject constructor) {
            assert (JSRuntime.isConstructor((Object)constructor));
            Object promiseResolve = this.getResolve.getValue((Object)constructor);
            if (!this.isCallable.executeBoolean(promiseResolve)) {
                throw Errors.createTypeErrorNotAFunction(promiseResolve);
            }
            return promiseResolve;
        }

        protected JSDynamicObject rejectPromise(AbstractTruffleException ex, PromiseCapabilityRecord promiseCapability) {
            if (this.callRejectNode == null || this.getErrorObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
            }
            Object error = this.getErrorObjectNode.execute(ex);
            this.callRejectNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), error));
            return promiseCapability.getPromise();
        }

        private void iteratorClose(IteratorRecord iteratorRecord) {
            if (this.iteratorCloseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.iteratorCloseNode = (IteratorCloseNode)this.insert(IteratorCloseNode.create(this.getContext()));
            }
            this.iteratorCloseNode.executeAbrupt(iteratorRecord.getIterator());
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected JSDynamicObject doNotObject(Object thisObj, Object iterable) {
            throw Errors.createTypeError("Cannot create promise from this type");
        }
    }

    public static abstract class RejectNode
    extends JSBuiltinNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapability;
        @Node.Child
        private JSFunctionCallNode callReject;

        protected RejectNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapability = NewPromiseCapabilityNode.create(context);
            this.callReject = JSFunctionCallNode.createCall();
        }

        @Specialization
        protected JSDynamicObject doObject(JSObject constructor, Object reason) {
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapability.execute((Object)constructor);
            this.callReject.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), reason));
            return promiseCapability.getPromise();
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected JSDynamicObject doNotObject(Object thisObj, Object iterable) {
            throw Errors.createTypeError("Cannot reject promise from this type");
        }
    }

    public static abstract class ResolveNode
    extends JSBuiltinNode {
        @Node.Child
        private PromiseResolveNode promiseResolve;

        protected ResolveNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.promiseResolve = PromiseResolveNode.create(context);
        }

        @Specialization
        protected JSDynamicObject doObject(JSObject constructor, Object value) {
            return this.promiseResolve.execute((Object)constructor, value);
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected JSDynamicObject doNotObject(Object thisObj, Object iterable) {
            throw Errors.createTypeError("Cannot resolve promise from this type");
        }
    }

    public static abstract class WithResolversNode
    extends JSBuiltinNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        private CreateObjectNode createObjectNode;
        @Node.Child
        private CreateDataPropertyNode definePromisePropertyNode;
        @Node.Child
        private CreateDataPropertyNode defineResolvePropertyNode;
        @Node.Child
        private CreateDataPropertyNode defineRejectPropertyNode;

        protected WithResolversNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.createObjectNode = CreateObjectNode.create(context);
            this.definePromisePropertyNode = CreateDataPropertyNode.create(context, Strings.PROMISE);
            this.defineResolvePropertyNode = CreateDataPropertyNode.create(context, Strings.RESOLVE);
            this.defineRejectPropertyNode = CreateDataPropertyNode.create(context, Strings.REJECT);
        }

        @Specialization
        protected JSObject withResolvers(Object thiz) {
            JSRealm realm = this.getRealm();
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.execute(thiz);
            JSObject obj = this.createObjectNode.execute(realm);
            this.definePromisePropertyNode.executeVoid((Object)obj, (Object)promiseCapability.getPromise());
            this.defineResolvePropertyNode.executeVoid((Object)obj, promiseCapability.getResolve());
            this.defineRejectPropertyNode.executeVoid((Object)obj, promiseCapability.getReject());
            return obj;
        }
    }

    public static abstract class PromiseTryNode
    extends JSBuiltinNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapabilityNode;
        @Node.Child
        private JSFunctionCallNode callCallbackFnNode;
        @Node.Child
        private JSFunctionCallNode callResolveNode;
        @Node.Child
        private JSFunctionCallNode callRejectNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        protected PromiseTryNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
            this.callCallbackFnNode = JSFunctionCallNode.createCall();
            this.callResolveNode = JSFunctionCallNode.createCall();
        }

        @Specialization
        protected final Object doObject(JSObject constructor, Object callbackfn, Object[] args) {
            PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.execute((Object)constructor);
            try {
                Object status = this.callCallbackFnNode.executeCall(JSArguments.create((Object)Undefined.instance, callbackfn, args));
                this.callResolveNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getResolve(), status));
            }
            catch (AbstractTruffleException ex) {
                this.rejectPromise(ex, promiseCapability);
            }
            return promiseCapability.getPromise();
        }

        private void rejectPromise(AbstractTruffleException ex, PromiseCapabilityRecord promiseCapability) {
            if (this.callRejectNode == null || this.getErrorObjectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.getContext()));
            }
            Object error = this.getErrorObjectNode.execute(ex);
            this.callRejectNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), error));
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected static Object doNotObject(Object thisObj, Object callbackfn, Object[] args) {
            throw Errors.createTypeError("Cannot create promise from this type");
        }
    }
}

