/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.version10.V10WireOperations;

public class V11WireOperations
extends V10WireOperations {
    private final List<DeferredAction> deferredActions = new ArrayList<DeferredAction>();

    public V11WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback) {
        super(connection, defaultWarningMessageCallback);
    }

    @Override
    public final void enqueueDeferredAction(DeferredAction deferredAction) {
        try (LockCloseable ignored = this.withLock();){
            this.deferredActions.add(deferredAction);
        }
    }

    @Override
    public final void processDeferredActions() {
        try (LockCloseable ignored = this.withLock();){
            if (this.deferredActions.size() == 0) {
                return;
            }
            DeferredAction[] actions = this.deferredActions.toArray(new DeferredAction[0]);
            this.deferredActions.clear();
            for (DeferredAction action : actions) {
                try {
                    action.processResponse(this.readResponse(action.getWarningMessageCallback()));
                }
                catch (IOException ex) {
                    action.onException(FbExceptionBuilder.forException(335544726).cause(ex).toSQLException());
                }
                catch (Exception ex) {
                    action.onException(ex);
                }
            }
        }
    }
}

